/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.CatLeap;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.EasingFunctions;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.world.entity.player.Player;

public class CatLeapAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(CatLeap.class).isDoing() || this.getTick() > 20;
    }

    @Override
    public boolean animatePre(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        return false;
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        CatLeap catLeap = parkourability.get(CatLeap.class);
        float phase = ((float)catLeap.getDoingTick() + transformer.getPartialTick()) / 20.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float factor = this.movingFactorFunc(phase);
        float animationFactor = 1.0f - phase * phase * phase * phase;
        transformer.rotateLeftArm((float)(-Math.toRadians(MathUtil.lerp(-25.0f, 170.0f, factor))), 0.0f, (float)(-Math.toRadians(MathUtil.lerp(24.0f, 5.0f, factor))), animationFactor).rotateRightArm((float)(-Math.toRadians(MathUtil.lerp(-25.0f, 170.0f, factor))), 0.0f, (float)Math.toRadians(MathUtil.lerp(24.0f, 5.0f, factor)), animationFactor).makeArmsNatural().rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(15.0f, 45.0f, factor)), 0.0f, 0.0f, animationFactor).rotateRightLeg((float)(-Math.toRadians(MathUtil.lerp(15.0f, 45.0f, factor))), 0.0f, 0.0f, animationFactor).makeLegsLittleMoving().end();
    }

    private float movingFactorFunc(float phase) {
        if ((double)phase > 0.2) {
            return 1.0f - EasingFunctions.CubicInOut((phase - 0.2f) * 1.25f);
        }
        return (float)(1.0 - 25.0 * ((double)phase - 0.2) * ((double)phase - 0.2));
    }
}

