/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.SettingActionLimitationScreen;
import com.alrex.parcool.client.gui.SettingBooleanConfigScreen;
import com.alrex.parcool.client.gui.SettingEnumConfigScreen;
import com.alrex.parcool.client.gui.SettingShowLimitationsScreen;
import com.alrex.parcool.common.info.ActionInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public abstract class ParCoolSettingScreen
extends Screen {
    private final ScreenSet<?>[] screenList;
    protected int currentScreen = 0;
    protected int topIndex = 0;
    protected int viewableItemCount = 0;
    protected static final int Checkbox_Item_Height = 21;
    protected final ColorTheme color;
    protected final BooleanSupplier serverPermissionReceived = info.getServerLimitation()::isReceived;
    protected final BooleanSupplier individualPermissionReceived = info.getIndividualLimitation()::isReceived;
    private static final Component MenuTitle = Component.m_237115_((String)"parcool.gui.title.setting");
    protected static final Component Header_ActionName = Component.m_237115_((String)"parcool.gui.text.actionName");
    protected static final Component Header_ServerPermission = Component.m_237113_((String)"G");
    protected static final Component Header_ServerPermissionText = Component.m_237115_((String)"parcool.gui.text.globalPermission");
    protected static final Component Header_IndividualPermission = Component.m_237113_((String)"I");
    protected static final Component Header_IndividualPermissionText = Component.m_237115_((String)"parcool.gui.text.individualPermission");
    protected static final Component Permission_Permitted = Component.m_237113_((String)"\u2713");
    protected static final Component Permission_Denied = Component.m_237113_((String)"\u00d7");
    protected static final Component Permission_Not_Received = Component.m_237113_((String)"\u00a74[Error] Permissions are not sent from a server.\n\nBy closing this setting menu, permissions will be sent again.\nIf it were not done, please report to the mod developer after checking whether ParCool is installed and re-login to the server.\u00a7r");

    public ParCoolSettingScreen(Component titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn);
        this.color = theme;
        this.screenList = new ScreenSet[]{new ScreenSet<SettingActionLimitationScreen>((Component)Component.m_237115_((String)"parcool.gui.text.action"), () -> new SettingActionLimitationScreen(this.f_96539_, info, theme)), new ScreenSet<SettingBooleanConfigScreen>((Component)Component.m_237113_((String)(I18n.m_118938_((String)"parcool.gui.text.config", (Object[])new Object[0]) + "1")), () -> new SettingBooleanConfigScreen(titleIn, info, theme)), new ScreenSet<SettingEnumConfigScreen>((Component)Component.m_237113_((String)(I18n.m_118938_((String)"parcool.gui.text.config", (Object[])new Object[0]) + "2")), () -> new SettingEnumConfigScreen(titleIn, info, theme)), new ScreenSet<SettingShowLimitationsScreen>((Component)Component.m_237115_((String)"parcool.gui.text.limitation"), () -> new SettingShowLimitationsScreen(titleIn, info, theme))};
    }

    public void m_6574_(@Nonnull Minecraft minecraft, int p_231152_2_, int p_231152_3_) {
        super.m_6574_(minecraft, p_231152_2_, p_231152_3_);
        this.mouseScrolled(0.0, 0.0, 0.0);
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float p_230430_4_) {
        super.m_88315_(graphics, mouseX, mouseY, p_230430_4_);
        this.m_280273_(graphics, mouseX, mouseY, p_230430_4_);
        Objects.requireNonNull(this.f_96547_);
        int topBarHeight = 9 * 2;
        int topBarItemWidth = (int)(1.2 * (double)Arrays.stream(this.screenList).map(it -> this.f_96547_.m_92852_((FormattedText)it.title)).max(Integer::compareTo).orElse(0).intValue());
        int topBarOffsetX = this.f_96543_ - topBarItemWidth * this.screenList.length;
        graphics.m_280024_(0, 0, this.f_96543_, topBarHeight, this.color.getTopBar1(), this.color.getTopBar2());
        this.renderSubHeaderAndFooter(graphics, this.screenList[this.currentScreen].title, this.isDownScrollable(), topBarHeight);
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        this.renderContents(graphics, mouseX, mouseY, p_230430_4_, topBarHeight + 9 * 2, 9 * 2);
        for (int i = 0; i < this.screenList.length; ++i) {
            ScreenSet<?> item = this.screenList[i];
            item.y = 0;
            item.x = topBarOffsetX + i * topBarItemWidth;
            item.width = topBarItemWidth;
            item.height = topBarHeight;
            boolean selected = this.currentScreen == i || item.isMouseIn(mouseX, mouseY);
            graphics.m_280653_(this.f_96547_, item.title, topBarOffsetX + i * topBarItemWidth + topBarItemWidth / 2, topBarHeight / 4 + 1, selected ? this.color.getText() : this.color.getSubText());
            graphics.m_280509_(item.x, 2, item.x + 1, topBarHeight - 3, this.color.getSeparator());
        }
        graphics.m_280509_(0, topBarHeight - 1, this.f_96543_, topBarHeight, this.color.getSeparator());
        int titleOffset = 0;
        if (!this.serverPermissionReceived.getAsBoolean() || !this.individualPermissionReceived.getAsBoolean()) {
            graphics.m_280509_(2, 2, topBarHeight - 3, topBarHeight - 3, -1118482);
            graphics.m_280509_(3, 3, topBarHeight - 4, topBarHeight - 4, -1179648);
            int n = topBarHeight / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280137_(this.f_96547_, "!", n, (topBarHeight - 9) / 2 + 1, 0xEEEEEE);
            if (2 <= mouseX && mouseX < topBarHeight - 3 && 1 <= mouseY && mouseY < topBarHeight - 3) {
                graphics.m_280666_(this.f_96547_, Collections.singletonList(Permission_Not_Received), mouseX, mouseY);
            }
            titleOffset = topBarHeight;
        }
        graphics.m_280430_(this.f_96547_, MenuTitle, titleOffset + 5, topBarHeight / 4 + 1, this.color.getText());
    }

    protected abstract void renderContents(GuiGraphics var1, int var2, int var3, float var4, int var5, int var6);

    protected void save() {
    }

    protected boolean isDownScrollable() {
        return false;
    }

    private void renderSubHeaderAndFooter(GuiGraphics graphics, Component title, boolean scrollable, int topOffset) {
        Objects.requireNonNull(this.f_96547_);
        int headerHeight = 9 * 2;
        graphics.m_280024_(0, topOffset, this.f_96543_, topOffset + headerHeight, this.color.getHeader1(), this.color.getHeader2());
        graphics.m_280024_(0, this.f_96544_ - headerHeight, this.f_96543_, this.f_96544_, this.color.getHeader1(), this.color.getHeader2());
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280653_(this.f_96547_, title, n, topOffset + 9 / 2 + 2, this.color.getStrongText());
        if (scrollable) {
            MutableComponent mutableComponent = Component.m_237113_((String)"\u2193");
            int n2 = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, (Component)mutableComponent, n2, this.f_96544_ - 9 - 9 / 2, this.color.getStrongText());
        }
    }

    public void m_280273_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, this.color.getBackground());
    }

    public void m_7379_() {
        this.save();
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 262: {
                this.save();
                Minecraft.m_91087_().m_91152_((Screen)this.screenList[(this.currentScreen + 1) % this.screenList.length].screenSupplier.get());
                break;
            }
            case 263: {
                this.save();
                Minecraft.m_91087_().m_91152_((Screen)this.screenList[(this.currentScreen - 1) % this.screenList.length].screenSupplier.get());
                break;
            }
            case 265: {
                this.mouseScrolled(0.0, 0.0, 1.0);
                break;
            }
            case 264: {
                this.mouseScrolled(0.0, 0.0, -1.0);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_, double p_299502_) {
        return this.mouseScrolled(p_94686_, p_94687_, p_94688_);
    }

    public boolean mouseScrolled(double x, double y, double value) {
        int scroll = (int)(-Math.signum(value));
        if (scroll <= 0 || this.isDownScrollable()) {
            this.topIndex += scroll;
        }
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int type) {
        for (ScreenSet<?> modeSet : this.screenList) {
            if (!modeSet.isMouseIn((int)mouseX, (int)mouseY) || type != 0) continue;
            this.save();
            Minecraft.m_91087_().m_91152_((Screen)modeSet.screenSupplier.get());
            return true;
        }
        return false;
    }

    private static class ScreenSet<T extends ParCoolSettingScreen> {
        final Supplier<T> screenSupplier;
        final Component title;
        int x;
        int y;
        int width;
        int height;

        boolean isMouseIn(double mouseX, double mouseY) {
            return (double)this.x < mouseX && mouseX < (double)(this.x + this.width) && (double)this.y < mouseY && mouseY < (double)(this.y + this.height);
        }

        public ScreenSet(Component title, Supplier<T> supplier) {
            this.title = title;
            this.screenSupplier = supplier;
        }
    }
}

