/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.ParCoolSettingScreen;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.network.SyncClientInformationMessage;
import com.alrex.parcool.config.ParCoolConfig;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.common.ForgeConfigSpec;

public class SettingActionLimitationScreen
extends ParCoolSettingScreen {
    private final ActionConfigSet[] actionList = new ActionConfigSet[ActionList.ACTIONS.size()];
    private final Checkbox[] actionButtons = new Checkbox[this.actionList.length];

    public SettingActionLimitationScreen(Component titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn, info, theme);
        this.currentScreen = 0;
        for (int i = 0; i < this.actionList.length; ++i) {
            this.actionList[i] = new ActionConfigSet(ActionList.getByIndex(i), info);
            this.actionButtons[i] = Checkbox.m_306644_((Component)Component.m_237113_((String)this.actionList[i].name), (Font)Minecraft.m_91087_().f_91062_).m_307950_(this.actionList[i].getter.getAsBoolean()).m_307310_(0, 0).m_307240_();
            this.actionButtons[i].m_293384_(21);
        }
    }

    @Override
    public boolean isDownScrollable() {
        return this.topIndex + this.viewableItemCount < this.actionButtons.length;
    }

    @Override
    public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int topOffset, int bottomOffset) {
        int offsetX = 40;
        Objects.requireNonNull(this.f_96547_);
        int headerHeight = (int)(9.0f * 1.5f);
        int contentOffsetY = topOffset + headerHeight + 2;
        int permissionColumnWidth = this.f_96547_.m_92852_((FormattedText)Permission_Permitted) * 5;
        int nameColumnWidth = this.f_96543_ - 80 - permissionColumnWidth * 2;
        int contentHeight = this.f_96544_ - contentOffsetY - bottomOffset;
        this.viewableItemCount = contentHeight / 21;
        int n = topOffset + headerHeight / 2;
        Objects.requireNonNull(this.f_96547_);
        int headerTextY = n - 9 / 2 + 1;
        graphics.m_280430_(this.f_96547_, Header_ActionName, 45, headerTextY, this.color.getText());
        graphics.m_280653_(this.f_96547_, Header_ServerPermission, 40 + nameColumnWidth + permissionColumnWidth / 2, headerTextY, this.color.getText());
        graphics.m_280653_(this.f_96547_, Header_IndividualPermission, 40 + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2, headerTextY, this.color.getText());
        for (Checkbox actionButton : this.actionButtons) {
            actionButton.m_93674_(0);
        }
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.actionButtons.length; ++i) {
            Checkbox button = this.actionButtons[i + this.topIndex];
            button.m_252865_(41);
            button.m_253211_(contentOffsetY + 21 * i);
            button.m_93674_(nameColumnWidth - 5);
            button.m_293384_(20);
            button.m_88315_(graphics, mouseX, mouseY, partialTick);
            graphics.m_280509_(40, button.m_252907_() + button.m_93694_(), this.f_96543_ - 40, button.m_252907_() + button.m_93694_() + 1, this.color.getSubSeparator());
            int rowY = contentOffsetY + 21 * i + 10;
            boolean permitted = this.actionList[this.topIndex + i].serverWideLimitation.getAsBoolean();
            Component component = permitted ? Permission_Permitted : Permission_Denied;
            int n2 = 40 + nameColumnWidth + permissionColumnWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, component, n2, rowY - 9 / 2, permitted ? 43520 : 0xAA0000);
            permitted = this.actionList[this.topIndex + i].individualLimitation.getAsBoolean();
            Component component2 = permitted ? Permission_Permitted : Permission_Denied;
            int n3 = 40 + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280653_(this.f_96547_, component2, n3, rowY - 9 / 2, permitted ? 43520 : 0xAA0000);
        }
        graphics.m_280509_(40, contentOffsetY, this.f_96543_ - 40, contentOffsetY - 1, this.color.getSeparator());
        graphics.m_280509_(40, topOffset, 41, this.f_96544_ - bottomOffset, this.color.getSeparator());
        graphics.m_280509_(40 + nameColumnWidth, topOffset, 40 + nameColumnWidth + 1, this.f_96544_ - bottomOffset, this.color.getSeparator());
        graphics.m_280509_(40 + nameColumnWidth + permissionColumnWidth, topOffset, 40 + nameColumnWidth + permissionColumnWidth + 1, this.f_96544_ - bottomOffset, this.color.getSeparator());
        graphics.m_280509_(40 + nameColumnWidth + permissionColumnWidth * 2, topOffset, 40 + nameColumnWidth + permissionColumnWidth * 2 + 1, this.f_96544_ - bottomOffset, this.color.getSeparator());
        int columnCenter = 40 + nameColumnWidth + permissionColumnWidth / 2;
        if (topOffset < mouseY && mouseY < topOffset + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            graphics.m_280666_(this.f_96547_, Collections.singletonList(Header_ServerPermissionText), mouseX, mouseY);
        }
        columnCenter = 40 + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2;
        if (topOffset < mouseY && mouseY < topOffset + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            graphics.m_280666_(this.f_96547_, Collections.singletonList(Header_IndividualPermissionText), mouseX, mouseY);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int type) {
        for (Checkbox button : this.actionButtons) {
            if (!button.m_6375_(mouseX, mouseY, type)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, type);
    }

    @Override
    protected void save() {
        for (int i = 0; i < this.actionList.length; ++i) {
            this.actionList[i].setter.accept(this.actionButtons[i].m_93840_());
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SyncClientInformationMessage.sync(player, true);
    }

    private static class ActionConfigSet {
        final String name;
        final Consumer<Boolean> setter;
        final BooleanSupplier getter;
        final BooleanSupplier serverWideLimitation;
        final BooleanSupplier individualLimitation;

        ActionConfigSet(Class<? extends Action> action, ActionInfo info) {
            this.name = Component.m_237115_((String)("parcool.action." + action.getSimpleName())).getString();
            ForgeConfigSpec.BooleanValue config = ParCoolConfig.Client.getPossibilityOf(action);
            this.setter = arg_0 -> ((ForgeConfigSpec.BooleanValue)config).set(arg_0);
            this.getter = () -> ((ForgeConfigSpec.BooleanValue)config).get();
            this.serverWideLimitation = () -> info.getServerLimitation().isPermitted(action);
            this.individualLimitation = () -> info.getIndividualLimitation().isPermitted(action);
        }
    }
}

