/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.RollAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.registries.ParCoolPoses;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Roll
extends Action {
    private int creativeCoolTime = 0;
    private boolean startRequired = false;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (player.m_7578_()) {
            if (KeyBindings.getKeyBreakfall().m_90857_() && KeyBindings.getKeyForward().m_90857_() && !parkourability.get(Dodge.class).isDoing() && !parkourability.get(Crawl.class).isDoing() && !player.m_20143_() && !player.m_6067_() && ParCoolConfig.Client.Booleans.EnableRollWhenCreative.get().booleanValue() && player.m_7500_() && parkourability.getAdditionalProperties().getLandingTick() <= 1 && player.m_20096_() && !this.isDoing() && this.creativeCoolTime == 0) {
                this.startRequired = true;
                this.creativeCoolTime = 20;
            }
            if (this.creativeCoolTime > 0) {
                --this.creativeCoolTime;
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        LocalPlayer clientPlayer = (LocalPlayer)player;
        Direction rollDirection = Direction.Front;
        if ((double)clientPlayer.f_108618_.f_108566_ < -0.5) {
            rollDirection = Direction.Right;
        } else if ((double)clientPlayer.f_108618_.f_108566_ > 0.5) {
            rollDirection = Direction.Left;
        } else if ((double)clientPlayer.f_108618_.f_108567_ < -0.5) {
            rollDirection = Direction.Back;
        }
        startInfo.putInt(rollDirection.ordinal());
        return this.startRequired;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < this.getRollMaxTick();
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.startRequired = false;
        Direction direction = Direction.values()[startData.getInt()];
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new RollAnimator(direction));
        }
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.startRequired = false;
        Direction direction = Direction.values()[startData.getInt()];
        double modifier = Math.sqrt(player.m_20205_());
        Vec3 vec = VectorUtil.fromYawDegree(player.f_20883_).m_82490_(modifier);
        switch (direction) {
            case Back: {
                vec = vec.m_82548_();
                break;
            }
            case Right: {
                vec = vec.m_82524_(-1.5707964f);
                break;
            }
            case Left: {
                vec = vec.m_82524_(1.5707964f);
            }
        }
        player.m_20334_(vec.m_7096_(), 0.0, vec.m_7094_());
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new RollAnimator(direction));
        }
        parkourability.getCancelMarks().addMarkerCancellingJump(this::isDoing);
    }

    public void startRoll(Player player) {
        this.startRequired = true;
    }

    public int getRollMaxTick() {
        return 9;
    }

    @Override
    public void onWorkingTick(Player player, Parkourability parkourability, IStamina stamina) {
        Pose pose = ParCoolPoses.ROLLING.get();
        player.m_20124_(pose);
    }

    public static enum Direction {
        Front,
        Back,
        Left,
        Right;

    }
}

