/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.PacketDistributor;

public class StartBreakfallMessage {
    UUID playerID = null;
    boolean justTimed = false;

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
        packet.writeBoolean(this.justTimed);
    }

    public static StartBreakfallMessage decode(FriendlyByteBuf packet) {
        StartBreakfallMessage message = new StartBreakfallMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        message.justTimed = packet.readBoolean();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            if (context.isClientSide()) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                if (!this.playerID.equals(player.m_20148_())) {
                    return;
                }
                Parkourability parkourability = Parkourability.get((Player)player);
                if (parkourability == null) {
                    return;
                }
                IStamina stamina = IStamina.get((Player)player);
                if (stamina == null) {
                    return;
                }
                parkourability.get(BreakfallReady.class).startBreakfall((Player)player, parkourability, stamina, this.justTimed);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(CustomPayloadEvent.Context context) {
    }

    public static void send(ServerPlayer player, boolean justTimed) {
        StartBreakfallMessage message = new StartBreakfallMessage();
        message.playerID = player.m_20148_();
        message.justTimed = justTimed;
        ParCool.CHANNEL_INSTANCE.send((Object)message, PacketDistributor.PLAYER.with((Object)player));
    }
}

