/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ClientSetting;
import com.alrex.parcool.server.limitation.Limitations;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;

public class SyncClientInformationMessage {
    private final ByteBuffer data = ByteBuffer.allocate(512);
    private UUID playerID = null;
    private boolean requestLimitations = false;

    public void encode(FriendlyByteBuf packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
        packet.writeBoolean(this.requestLimitations);
        packet.writeBytes(this.data);
        this.data.rewind();
    }

    public static SyncClientInformationMessage decode(FriendlyByteBuf packet) {
        SyncClientInformationMessage message = new SyncClientInformationMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        message.requestLimitations = packet.readBoolean();
        while (packet.isReadable()) {
            message.data.put(packet.readByte());
        }
        message.data.flip();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            Parkourability parkourability;
            ServerPlayer player;
            if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null) {
                    return;
                }
                player = world.m_46003_(this.playerID);
                if (player == null) {
                    return;
                }
            } else {
                ServerPlayer serverPlayer = context.getSender();
                player = serverPlayer;
                if (player == null) {
                    return;
                }
                ParCool.CHANNEL_INSTANCE.send((Object)this, PacketDistributor.ALL.noArg());
                if (this.requestLimitations) {
                    Limitations.update(serverPlayer);
                }
            }
            if ((parkourability = Parkourability.get((Player)player)) == null) {
                return;
            }
            if (!player.m_7578_()) {
                parkourability.getActionInfo().setClientSetting(ClientSetting.readFrom(this.data));
                this.data.rewind();
            }
        });
        context.setPacketHandled(true);
    }

    public void handleServer(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ParCool.CHANNEL_INSTANCE.send((Object)this, PacketDistributor.ALL.noArg());
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            if (this.requestLimitations) {
                Limitations.update(player);
            }
            parkourability.getActionInfo().setClientSetting(ClientSetting.readFrom(this.data));
            this.data.rewind();
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(LocalPlayer player, boolean requestSendLimitation) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        SyncClientInformationMessage message = new SyncClientInformationMessage();
        parkourability.getClientInfo().writeTo(message.data);
        message.data.flip();
        message.playerID = player.m_20148_();
        message.requestLimitations = requestSendLimitation;
        ParCool.CHANNEL_INSTANCE.send((Object)message, PacketDistributor.SERVER.noArg());
    }
}

