/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.potion;

import com.alrex.parcool.common.potion.Potions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ParCoolBrewingRecipe
implements IBrewingRecipe {
    private static final List<MixRecipe> MIXES;

    @Nullable
    private static Potion mix(ItemStack input, ItemStack ingredient) {
        Potion inputPotion = PotionUtils.m_43579_((ItemStack)input);
        Item ingredientItem = ingredient.m_41720_();
        for (MixRecipe recipe : MIXES) {
            if (recipe.from.get() != inputPotion || recipe.ingredient.get() != ingredientItem) continue;
            return recipe.result.get();
        }
        return null;
    }

    private static boolean isPotionIngredient(Item item) {
        return MIXES.stream().anyMatch(it -> item == it.ingredient.get());
    }

    public boolean isInput(ItemStack input) {
        Item item = input.m_41720_();
        return item == Items.f_42589_ || item == Items.f_42736_ || item == Items.f_42739_;
    }

    public boolean isIngredient(ItemStack ingredient) {
        Item item = ingredient.m_41720_();
        return ParCoolBrewingRecipe.isPotionIngredient(item);
    }

    @Nonnull
    public ItemStack getOutput(ItemStack input, @Nonnull ItemStack ingredient) {
        Potion result;
        if (!input.m_41619_() && !ingredient.m_41619_() && this.isIngredient(ingredient) && (result = ParCoolBrewingRecipe.mix(input, ingredient)) != null) {
            return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)input.m_41720_()), (Potion)result);
        }
        return ItemStack.f_41583_;
    }

    static {
        MixRecipe[] mixRecipeArray = new MixRecipe[4];
        mixRecipeArray[0] = new MixRecipe(() -> net.minecraft.world.item.alchemy.Potions.f_43602_, () -> Items.f_42675_, () -> Potions.POOR_ENERGY_DRINK.get());
        mixRecipeArray[1] = new MixRecipe(() -> net.minecraft.world.item.alchemy.Potions.f_43602_, () -> Items.f_42581_, () -> Potions.POOR_ENERGY_DRINK.get());
        mixRecipeArray[2] = new MixRecipe(() -> Potions.POOR_ENERGY_DRINK.get(), () -> Items.f_42692_, () -> Potions.ENERGY_DRINK.get());
        mixRecipeArray[3] = new MixRecipe(() -> net.minecraft.world.item.alchemy.Potions.f_43602_, () -> Items.f_42692_, () -> Potions.ENERGY_DRINK.get());
        MIXES = Arrays.asList(mixRecipeArray);
    }

    private static class MixRecipe {
        private final Supplier<Potion> from;
        private final Supplier<Item> ingredient;
        private final Supplier<Potion> result;

        MixRecipe(Supplier<Potion> from, Supplier<Item> ingredient, Supplier<Potion> result) {
            this.from = from;
            this.ingredient = ingredient;
            this.result = result;
        }
    }
}

