/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.api;

import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.stamina.ReadonlyStamina;
import com.alrex.parcool.common.stamina.LocalStamina;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Stamina {
    private final ReadonlyStamina staminaInstance;
    private final boolean isLocalPlayer;

    public static Stamina get(Player player) {
        return new Stamina((ReadonlyStamina)player.getData(Attachments.STAMINA), player.isLocalPlayer());
    }

    private Stamina(ReadonlyStamina staminaInstance, boolean local) {
        this.staminaInstance = staminaInstance;
        this.isLocalPlayer = local;
    }

    public int getMaxValue() {
        return this.staminaInstance.max();
    }

    public int getValue() {
        return this.staminaInstance.value();
    }

    public boolean isExhausted() {
        return this.staminaInstance.isExhausted();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void consume(int value) {
        if (!this.isLocalPlayer) {
            return;
        }
        LocalStamina stamina = LocalStamina.get();
        if (stamina == null) {
            return;
        }
        stamina.consume(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void recover(int value) {
        if (!this.isLocalPlayer) {
            return;
        }
        LocalStamina stamina = LocalStamina.get();
        if (stamina == null) {
            return;
        }
        stamina.recover(value);
    }
}

