/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.api.unstable;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.stamina.StaminaType;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.server.limitation.Limitation;
import com.alrex.parcool.server.limitation.Limitations;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public abstract class Limitation {
    private final com.alrex.parcool.server.limitation.Limitation instance;

    public static Limitation get(ServerPlayer player, ID limitationID) {
        return new NormalLimitation(player, Limitations.createLimitationOf(player.getUUID(), limitationID.convert()));
    }

    public static Limitation getIndividual(ServerPlayer player) {
        return new NormalLimitation(player, Limitations.createLimitationOf(player.getUUID(), Limitations.INDIVIDUAL_ID));
    }

    public static Limitation getGlobal(MinecraftServer server) {
        return new GlobalLimitation(server);
    }

    public Limitation set(ParCoolConfig.Server.Booleans item, boolean value) {
        this.instance.set(item, value);
        return this;
    }

    public Limitation set(ParCoolConfig.Server.Integers item, int value) {
        this.instance.set(item, value);
        return this;
    }

    public Limitation set(ParCoolConfig.Server.Doubles item, double value) {
        this.instance.set(item, value);
        return this;
    }

    public Limitation setStaminaType(StaminaType type) {
        this.instance.setForcedStamina(type);
        return this;
    }

    public Limitation setDefault() {
        this.instance.setAllDefault();
        return this;
    }

    public Limitation permit(Class<? extends Action> action, boolean permission) {
        this.instance.setPossibilityOf(action, permission);
        return this;
    }

    public Limitation setLeastStaminaConsumption(Class<? extends Action> action, int value) {
        this.instance.setLeastStaminaConsumption(action, value);
        return this;
    }

    public Limitation enable() {
        this.instance.setEnabled(true);
        return this;
    }

    public Limitation disable() {
        this.instance.setEnabled(false);
        return this;
    }

    public boolean get(ParCoolConfig.Server.Booleans item) {
        return this.instance.get(item);
    }

    public int get(ParCoolConfig.Server.Integers item) {
        return this.instance.get(item);
    }

    public double get(ParCoolConfig.Server.Doubles item) {
        return this.instance.get(item);
    }

    public StaminaType getStaminaType() {
        return this.instance.getForcedStamina();
    }

    public boolean isPermitted(Class<? extends Action> action) {
        return this.instance.isPermitted(action);
    }

    public int getLeastStaminaConsumption(Class<? extends Action> action) {
        return this.instance.getLeastStaminaConsumption(action);
    }

    public boolean isEnabled() {
        return this.instance.isEnabled();
    }

    public abstract void apply();

    public static boolean delete(ID limitationID) {
        return Limitations.delete(limitationID.convert());
    }

    private Limitation(com.alrex.parcool.server.limitation.Limitation instance) {
        this.instance = instance;
    }

    private static class NormalLimitation
    extends Limitation {
        private final ServerPlayer player;

        private NormalLimitation(ServerPlayer player, com.alrex.parcool.server.limitation.Limitation instance) {
            super(instance);
            this.player = player;
        }

        @Override
        public void apply() {
            Limitations.update(this.player);
        }
    }

    public static class ID {
        public final String group;
        public final String name;

        public ID(String group, String name) {
            this.group = group;
            this.name = name;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        Limitation.ID convert() {
            return new Limitation.ID(this.group, this.name);
        }

        public String toString() {
            return this.group + ":" + this.name;
        }
    }

    private static class GlobalLimitation
    extends Limitation {
        private final MinecraftServer server;

        private GlobalLimitation(MinecraftServer server) {
            super(Limitations.getGlobalLimitation());
            this.server = server;
        }

        @Override
        public void apply() {
            for (ServerPlayer player : this.server.getPlayerList().getPlayers()) {
                Limitations.update(player);
            }
        }
    }
}

