/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.Parkourability;
import net.minecraft.world.entity.player.Player;

public class WallJumpAnimator
extends Animator {
    private boolean swingRightArm;
    private final int maxTick = 14;

    public WallJumpAnimator(boolean swingRightArm) {
        this.swingRightArm = swingRightArm;
    }

    float getFactor(float phase) {
        float x = phase - 0.2f;
        if ((double)phase < 0.2) {
            return 1.0f - 25.0f * x * x;
        }
        return 1.0f - 1.5625f * x * x;
    }

    float getFadeFactor(float phase) {
        return (float)(1.0 - Math.pow(2.0f * phase - 1.0f, 4.0));
    }

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return this.getTick() >= 14;
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 14.0f;
        float factor = this.getFactor(phase);
        float fadeFactor = this.getFadeFactor(phase);
        int sign = this.swingRightArm ? 1 : -1;
        transformer.rotateRightLeg((float)Math.toRadians((float)sign * factor * 60.0f), 0.0f, 0.0f, fadeFactor).rotateLeftLeg((float)Math.toRadians((float)sign * factor * -60.0f), 0.0f, 0.0f, fadeFactor).rotateRightArm((float)Math.toRadians(this.swingRightArm ? (double)(factor * -120.0f) : (double)(factor * 55.0f)), 0.0f, (float)Math.toRadians(-35.0f * factor), fadeFactor).rotateLeftArm((float)Math.toRadians(this.swingRightArm ? (double)(factor * 55.0f) : (double)(factor * -120.0f)), 0.0f, (float)Math.toRadians(35.0f * factor), fadeFactor).makeArmsNatural().end();
    }

    @Override
    public void rotatePost(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 14.0f;
        float factor = this.getFactor(phase);
        rotator.startBasedCenter().rotatePitchFrontward(factor * 20.0f).rotateRollRightward((float)((this.swingRightArm ? -1 : 1) * 15) * factor).end();
    }
}

