/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.client.animation.Animation;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.Parkourability;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.stamina.ReadonlyStamina;
import com.alrex.parcool.common.network.payload.ActionStatePayload;
import com.alrex.parcool.common.network.payload.StaminaPayload;
import com.alrex.parcool.common.stamina.LocalStamina;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ActionProcessor {
    private final ByteBuffer bufferOfPostState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfPreState = ByteBuffer.allocate(128);
    private final ByteBuffer bufferOfStarting = ByteBuffer.allocate(128);
    private int staminaSyncCoolTimeTick = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTickInClient(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide()) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        animation.tick(player, parkourability);
    }

    @SubscribeEvent
    public void onTick(PlayerTickEvent.Pre event) {
        LocalStamina stamina;
        boolean needSync;
        Player player = event.getEntity();
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        List<Action> actions = parkourability.getList();
        boolean bl = needSync = player.level().isClientSide() && player.isLocalPlayer();
        if (needSync && ((stamina = LocalStamina.get()) == null || !stamina.isAvailable())) {
            return;
        }
        LinkedList<ActionStatePayload.Entry> syncStates = new LinkedList<ActionStatePayload.Entry>();
        parkourability.getAdditionalProperties().onTick(player, parkourability);
        block0: for (Action action : actions) {
            StaminaConsumeTiming timing = action.getStaminaConsumeTiming();
            if (needSync) {
                this.bufferOfPreState.clear();
                action.saveSynchronizedState(this.bufferOfPreState);
                this.bufferOfPreState.flip();
            }
            if (action.isDoing()) {
                action.setDoingTick(action.getDoingTick() + 1);
                action.setNotDoingTick(0);
            } else {
                action.setDoingTick(0);
                action.setNotDoingTick(action.getNotDoingTick() + 1);
            }
            action.onTick(player, parkourability);
            if (player.level().isClientSide()) {
                action.onClientTick(player, parkourability);
            } else {
                action.onServerTick(player, parkourability);
            }
            if (player.isLocalPlayer()) {
                if (action.isDoing()) {
                    boolean canContinue = action.canContinue(player, parkourability);
                    if (!canContinue) {
                        action.setDoing(false);
                        action.onStopInLocalClient(player);
                        action.onStop(player);
                        NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StopEvent(player, action));
                        syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Finish, new byte[0]));
                    }
                } else {
                    this.bufferOfStarting.clear();
                    boolean start = parkourability.getActionInfo().can(action.getClass()) && !((ReadonlyStamina)player.getData(Attachments.STAMINA)).isExhausted() && !((ParCoolActionEvent.TryToStartEvent)NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.TryToStartEvent(player, action))).isCanceled() && action.canStart(player, parkourability, this.bufferOfStarting);
                    this.bufferOfStarting.flip();
                    if (start) {
                        LocalStamina stamina2;
                        action.setDoing(true);
                        action.onStartInLocalClient(player, parkourability, this.bufferOfStarting);
                        this.bufferOfStarting.rewind();
                        action.onStart(player, parkourability);
                        NeoForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StartEvent(player, action));
                        byte[] data = new byte[this.bufferOfStarting.remaining()];
                        this.bufferOfStarting.get(data);
                        syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Start, data));
                        if (timing == StaminaConsumeTiming.OnStart && (stamina2 = LocalStamina.get()) != null) {
                            stamina2.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                }
            }
            if (action.isDoing()) {
                action.onWorkingTick(player, parkourability);
                if (player.level().isClientSide()) {
                    action.onWorkingTickInClient(player, parkourability);
                    if (player.isLocalPlayer()) {
                        LocalStamina stamina3;
                        action.onWorkingTickInLocalClient(player, parkourability);
                        if (timing == StaminaConsumeTiming.OnWorking && (stamina3 = LocalStamina.get()) != null) {
                            stamina3.consume(parkourability.getActionInfo().getStaminaConsumptionOf(action.getClass()));
                        }
                    }
                } else {
                    action.onWorkingTickInServer(player, parkourability);
                }
            }
            if (!needSync) continue;
            this.bufferOfPostState.clear();
            action.saveSynchronizedState(this.bufferOfPostState);
            this.bufferOfPostState.flip();
            if (this.bufferOfPostState.limit() == this.bufferOfPreState.limit()) {
                while (this.bufferOfPreState.hasRemaining()) {
                    if (this.bufferOfPostState.get() == this.bufferOfPreState.get()) continue;
                    this.bufferOfPostState.rewind();
                    byte[] data = new byte[this.bufferOfPostState.remaining()];
                    this.bufferOfPostState.get(data);
                    syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Normal, data));
                    continue block0;
                }
                continue;
            }
            this.bufferOfPostState.rewind();
            byte[] data = new byte[this.bufferOfPostState.remaining()];
            this.bufferOfPostState.get(data);
            syncStates.addLast(new ActionStatePayload.Entry(action.getClass(), ActionStatePayload.Entry.Type.Normal, data));
        }
        if (needSync) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ActionStatePayload(player.getUUID(), syncStates), (CustomPacketPayload[])new CustomPacketPayload[0]);
            LocalStamina stamina4 = LocalStamina.get();
            if (stamina4 != null) {
                ++this.staminaSyncCoolTimeTick;
                if (this.staminaSyncCoolTimeTick > 5) {
                    this.staminaSyncCoolTimeTick = 0;
                    PacketDistributor.sendToServer((CustomPacketPayload)new StaminaPayload(player.getUUID(), (ReadonlyStamina)player.getData(Attachments.STAMINA)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (stamina4.isExhausted()) {
                    player.setSprinting(false);
                }
                stamina4.onTick();
                stamina4.sync();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTick(RenderFrameEvent.Pre event) {
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientPlayer == null) {
            return;
        }
        for (Player player : clientPlayer.getCommandSenderWorld().players()) {
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            List<Action> actions = parkourability.getList();
            for (Action action : actions) {
                action.onRenderTick((RenderFrameEvent)event, player, parkourability);
            }
            Animation animation = Animation.get(player);
            if (animation == null) {
                return;
            }
            animation.onRenderTick((RenderFrameEvent)event, player, parkourability);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onViewRender(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        Animation animation = Animation.get((Player)player);
        if (animation == null) {
            return;
        }
        animation.cameraSetup(event, player, parkourability);
    }
}

