/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.Actions;
import com.alrex.parcool.common.action.AdditionalProperties;
import com.alrex.parcool.common.action.CancelMarks;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.info.ClientSetting;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;

public class Parkourability {
    private final ActionInfo info;
    private final AdditionalProperties properties = new AdditionalProperties();
    private final CancelMarks cancelMarks = new CancelMarks();
    private final List<Action> actions = Actions.constructActionsList();
    private final HashMap<Class<? extends Action>, Action> actionsMap = new HashMap((int)((double)this.actions.size() * 1.5));

    @Nullable
    public static Parkourability get(Player player) {
        return Registry.get(player);
    }

    public Parkourability() {
        for (Action action : this.actions) {
            this.actionsMap.put(action.getClass(), action);
        }
        this.info = new ActionInfo();
    }

    public <T extends Action> T get(Class<T> action) {
        Action value = this.actionsMap.getOrDefault(action, null);
        if (value == null) {
            throw new IllegalArgumentException("The Action instance is not registered:" + action.getSimpleName());
        }
        return (T)value;
    }

    public short getActionID(Action instance) {
        return Actions.getIndexOf(instance.getClass());
    }

    @Nullable
    public Action getActionFromID(short id) {
        if (0 <= id && id < this.actions.size()) {
            return this.actions.get(id);
        }
        return null;
    }

    public AdditionalProperties getAdditionalProperties() {
        return this.properties;
    }

    public CancelMarks getCancelMarks() {
        return this.cancelMarks;
    }

    public ActionInfo getActionInfo() {
        return this.info;
    }

    public ClientSetting getClientInfo() {
        return this.info.getClientSetting();
    }

    public List<Action> getList() {
        return this.actions;
    }

    public void CopyFrom(Parkourability original) {
        this.getActionInfo().setClientSetting(original.getActionInfo().getClientSetting());
        this.getActionInfo().setServerLimitation(original.getActionInfo().getServerLimitation());
    }

    public static class Registry {
        private static final TreeMap<UUID, Parkourability> mapClient = new TreeMap();
        private static final TreeMap<UUID, Parkourability> mapServer = new TreeMap();

        @Nullable
        private static Parkourability get(Player player) {
            return player.level().isClientSide() ? mapClient.get(player.getUUID()) : mapServer.get(player.getUUID());
        }

        public static void setupInClient(UUID id) {
            mapClient.putIfAbsent(id, new Parkourability());
        }

        public static void setupInServer(UUID id) {
            mapServer.putIfAbsent(id, new Parkourability());
        }

        public static void unloadInClient(UUID id) {
            mapClient.remove(id);
        }

        public static void unloadInServer(UUID id) {
            mapServer.remove(id);
        }
    }
}

