/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.Animation;
import com.alrex.parcool.client.animation.impl.FastSwimAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.Parkourability;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForgeMod;

public class FastSwim
extends Action {
    private static final ResourceLocation FAST_SWIM_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"parcool", (String)"modifier.speed.fastswim");
    private double speedModifier = 0.0;
    private boolean toggleStatus;

    public double getSpeedModifier(ActionInfo info) {
        return Math.min(info.getClientSetting().get(ParCoolConfig.Client.Doubles.FastSwimSpeedModifier), info.getServerLimitation().get(ParCoolConfig.Server.Doubles.MaxFastSwimSpeedModifier));
    }

    @Override
    public boolean canStart(Player player, Parkourability parkourability, ByteBuffer startInfo) {
        return this.canContinue(player, parkourability);
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability) {
        return player.isInWaterOrBubble() && player.getVehicle() == null && !player.isFallFlying() && player.isSprinting() && player.isSwimming() && !parkourability.get(FastRun.class).isDoing() && (ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.PressKey && KeyBindings.getKeyFastRunning().isDown() || ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Toggle && this.toggleStatus || ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Auto);
    }

    @Override
    public void onClientTick(Player player, Parkourability parkourability) {
        if (player.isLocalPlayer()) {
            if (ParCoolConfig.Client.FastRunControl.get() == FastRun.ControlType.Toggle && parkourability.getAdditionalProperties().getSprintingTick() > 3 && player.isInWaterOrBubble() && player.isSwimming()) {
                if (KeyRecorder.keyFastRunning.isPressed()) {
                    this.toggleStatus = !this.toggleStatus;
                }
            } else {
                this.toggleStatus = false;
            }
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new FastSwimAnimator());
        }
    }

    @Override
    public void onStartInServer(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.speedModifier = parkourability.get(FastSwim.class).getSpeedModifier(parkourability.getActionInfo());
    }

    @Override
    public void onServerTick(Player player, Parkourability parkourability) {
        AttributeInstance attr = player.getAttribute(NeoForgeMod.SWIM_SPEED);
        if (attr == null) {
            return;
        }
        if (attr.getModifier(FAST_SWIM_MODIFIER) != null) {
            attr.removeModifier(FAST_SWIM_MODIFIER);
        }
        if (this.isDoing()) {
            player.setSprinting(true);
            attr.addTransientModifier(new AttributeModifier(FAST_SWIM_MODIFIER, this.speedModifier / 8.0, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }
}

