/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.stamina;

import com.alrex.parcool.common.attachment.Attachments;
import com.alrex.parcool.common.attachment.stamina.ReadonlyStamina;
import com.alrex.parcool.common.stamina.IParCoolStaminaHandler;
import com.alrex.parcool.common.stamina.StaminaType;
import com.alrex.parcool.common.stamina.handlers.InfiniteStaminaHandler;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LocalStamina {
    @Nullable
    private static LocalStamina instance = null;
    private final LocalPlayer player;
    @Nullable
    private StaminaType currentType = null;
    @Nullable
    private IParCoolStaminaHandler handler = null;
    private int oldValue;
    private int value;

    @Nullable
    public static LocalStamina get() {
        return instance;
    }

    public static void setup(LocalPlayer player) {
        instance = new LocalStamina(player);
    }

    public static void unload() {
        instance = null;
    }

    private LocalStamina(LocalPlayer player) {
        this.player = player;
    }

    public boolean isAvailable() {
        return this.handler != null && this.currentType != null;
    }

    public boolean isInfinite() {
        return this.player.isCreative() || this.player.isSpectator() || this.handler instanceof InfiniteStaminaHandler;
    }

    public void changeType(StaminaType type) {
        this.currentType = type;
        this.handler = type.newHandler();
        this.player.setData(Attachments.STAMINA, (Object)this.handler.initializeStamina(this.player, (ReadonlyStamina)this.player.getData(Attachments.STAMINA)));
    }

    public boolean isExhausted() {
        return ((ReadonlyStamina)this.player.getData(Attachments.STAMINA)).isExhausted();
    }

    public int getValue() {
        return ((ReadonlyStamina)this.player.getData(Attachments.STAMINA)).value();
    }

    public int getMax() {
        return ((ReadonlyStamina)this.player.getData(Attachments.STAMINA)).max();
    }

    public void consume(int value) {
        if (this.player.isCreative() || this.player.isSpectator()) {
            return;
        }
        if (this.handler == null) {
            return;
        }
        this.player.setData(Attachments.STAMINA, (Object)this.handler.consume(this.player, (ReadonlyStamina)this.player.getData(Attachments.STAMINA), value));
    }

    public void recover(int value) {
        if (this.player.isCreative() || this.player.isSpectator()) {
            return;
        }
        if (this.handler == null) {
            return;
        }
        this.player.setData(Attachments.STAMINA, (Object)this.handler.recover(this.player, (ReadonlyStamina)this.player.getData(Attachments.STAMINA), value));
    }

    public void onTick() {
        if (this.handler == null) {
            return;
        }
        this.player.setData(Attachments.STAMINA, (Object)this.handler.onTick(this.player, (ReadonlyStamina)this.player.getData(Attachments.STAMINA)));
    }

    public void sync() {
        ((ReadonlyStamina)this.player.getData(Attachments.STAMINA)).sync();
    }
}

