/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.network;

import com.google.common.collect.Maps;
import com.sekwah.sekcphysics.SekCPhysics;
import com.sekwah.sekcphysics.settings.ModSettings;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class UsageReport {
    private final Timer threadTrigger = new Timer("UsageReport Timer", true);
    private final URL reportURL;
    private final String uniqueID = UUID.randomUUID().toString();
    private final Map reportData = Maps.newHashMap();
    private final boolean isClient;
    private boolean optOut = false;
    private final Object syncLock = new Object();
    private int reportCounter = 0;

    public UsageReport(boolean isClient) {
        this.isClient = isClient;
        try {
            this.reportURL = new URL("http://report.sekwah.com/sekc-physics/");
        }
        catch (MalformedURLException malformedurlexception) {
            throw new IllegalArgumentException();
        }
    }

    public void startUsageReport() {
        if (ModSettings.usageReportMod == 0 || ModSettings.usageReportMod == 1) {
            this.addBase();
            if (ModSettings.usageReportMod == 0) {
                this.addStats();
            }
            this.threadTrigger.schedule(new TimerTask(){
                private static final String __OBFID = "CL_00001516";

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = UsageReport.this.syncLock;
                    synchronized (object) {
                        if (ModSettings.usageReportMod == 0) {
                            UsageReport.this.addMemoryStats();
                        }
                        UsageReport.this.addData("reportCounter", ++UsageReport.this.reportCounter);
                    }
                    SekCPhysics.logger.info("Sending UsageReport data");
                    SekCPhysics.logger.info(UsageReport.this.sendData(UsageReport.this.reportURL, UsageReport.this.buildPostString(UsageReport.this.reportData)));
                }
            }, 0L, 890000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(String dataName, Object data) {
        Object object1 = this.syncLock;
        Object object = this.syncLock;
        synchronized (object) {
            this.reportData.put(dataName, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeData(String dataName) {
        Object object1 = this.syncLock;
        Object object = this.syncLock;
        synchronized (object) {
            this.reportData.remove(dataName);
        }
    }

    public void addBase() {
        this.addData("uuid", this.uniqueID);
        this.addData("version", "0.1.0");
    }

    public void addStats() {
        this.addData("os_name", System.getProperty("os.name"));
        this.addData("os_version", System.getProperty("os.version"));
        this.addData("os_architecture", System.getProperty("os.arch"));
        this.addData("java_version", System.getProperty("java.version"));
    }

    public void addMemoryStats() {
        this.addData("memory_total", Runtime.getRuntime().totalMemory());
        this.addData("memory_max", Runtime.getRuntime().maxMemory());
        this.addData("memory_free", Runtime.getRuntime().freeMemory());
        this.addData("cpu_cores", Runtime.getRuntime().availableProcessors());
    }

    public void addOtherData() {
    }

    public String buildPostString(Map map) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            if (stringbuilder.length() > 0) {
                stringbuilder.append('&');
            }
            try {
                stringbuilder.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                SekCPhysics.logger.error("Unsupported Encoding in report data");
                e.printStackTrace();
            }
            if (entry.getValue() == null) continue;
            stringbuilder.append('=');
            try {
                stringbuilder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                SekCPhysics.logger.error("Unsupported Encoding in report data");
                e.printStackTrace();
            }
        }
        return stringbuilder.toString();
    }

    public String sendData(URL url, String dataString) {
        try {
            String s1;
            Proxy proxy;
            Proxy proxy2 = proxy = FMLCommonHandler.instance().getMinecraftServerInstance() == null ? null : FMLCommonHandler.instance().getMinecraftServerInstance().func_110454_ao();
            if (proxy == null) {
                proxy = Proxy.NO_PROXY;
            }
            HttpURLConnection httpurlconnection = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
            httpurlconnection.setRequestMethod("POST");
            httpurlconnection.setRequestProperty("Content-Type", "application/posX-www-form-urlencoded");
            httpurlconnection.setRequestProperty("Content-Length", "" + dataString.getBytes().length);
            httpurlconnection.setRequestProperty("Content-Language", "en-US");
            httpurlconnection.setUseCaches(false);
            httpurlconnection.setDoInput(true);
            httpurlconnection.setDoOutput(true);
            DataOutputStream dataoutputstream = new DataOutputStream(httpurlconnection.getOutputStream());
            dataoutputstream.writeBytes(dataString);
            dataoutputstream.flush();
            dataoutputstream.close();
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(httpurlconnection.getInputStream()));
            StringBuffer stringbuffer = new StringBuffer();
            while ((s1 = bufferedreader.readLine()) != null) {
                stringbuffer.append(s1);
                stringbuffer.append('\r');
            }
            bufferedreader.close();
            return stringbuffer.toString();
        }
        catch (Exception e) {
            SekCPhysics.logger.error("Error sending the usage report.");
            e.printStackTrace();
            return "";
        }
    }
}

