/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.generation;

import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.ragdoll.generation.data.ConstraintData;
import com.sekwah.sekcphysics.ragdoll.generation.data.RagdollData;
import com.sekwah.sekcphysics.ragdoll.generation.data.TriangleData;
import com.sekwah.sekcphysics.ragdoll.parts.Constraint;
import com.sekwah.sekcphysics.ragdoll.parts.SkeletonPoint;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class RagdollConstructor {
    private HashMap<String, SkeletonPoint> skeletonPointHashMap = new HashMap();
    private LinkedList<Constraint> constraintLinkedList = new LinkedList();
    private HashMap<String, Triangle> triangleHashMap = new HashMap();

    public RagdollConstructor(RagdollData creationData) {
        for (Map.Entry<String, PointD> entry : creationData.getPointMap().entrySet()) {
            PointD point = entry.getValue();
            this.skeletonPointHashMap.put(entry.getKey(), new SkeletonPoint(point.x, point.y, point.z, 0.15f * creationData.getScale()));
        }
        for (ConstraintData constraintData : creationData.getConstraints()) {
            this.constraintLinkedList.add(new Constraint(this.getSkeletonPoint(constraintData.part1), this.getSkeletonPoint(constraintData.part2)));
        }
        for (Map.Entry entry : creationData.getTriangleMap().entrySet()) {
            TriangleData triangleData = (TriangleData)entry.getValue();
            this.triangleHashMap.put((String)entry.getKey(), new Triangle(this.getSkeletonPoint(triangleData.getPoint(0)), this.getSkeletonPoint(triangleData.getPoint(1)), this.getSkeletonPoint(triangleData.getPoint(2))));
        }
    }

    public SkeletonPoint getSkeletonPoint(String point) {
        SkeletonPoint skeletonPoint = this.skeletonPointHashMap.get(point);
        return skeletonPoint;
    }

    public SkeletonPoint[] getSkeletonPoints() {
        return this.skeletonPointHashMap.values().toArray(new SkeletonPoint[0]);
    }

    public Constraint[] getConstraints() {
        return this.constraintLinkedList.toArray(new Constraint[0]);
    }

    public Triangle getTriangle(String triangleName) {
        Triangle triangle = this.triangleHashMap.get(triangleName);
        return triangle;
    }

    public Triangle[] getTriangles() {
        return this.triangleHashMap.values().toArray(new Triangle[0]);
    }
}

