/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.generation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sekwah.sekcphysics.SekCPhysics;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.ragdoll.generation.data.ModelConstructData;
import com.sekwah.sekcphysics.ragdoll.generation.data.ModelData;
import com.sekwah.sekcphysics.ragdoll.generation.data.RagdollData;
import com.sekwah.sekcphysics.ragdoll.generation.data.RagdollInvalidDataException;
import com.sekwah.sekcphysics.ragdoll.generation.data.ResourceData;
import com.sekwah.sekcphysics.ragdoll.generation.data.tracker.TrackerData;
import com.sekwah.sekcphysics.ragdoll.generation.data.tracker.TriangleTrackerData;
import com.sekwah.sekcphysics.ragdoll.generation.data.tracker.VertexTrackerData;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.logging.log4j.Level;

public class RagdollGenerator {
    private void generateRagdollsFrom(String modid) {
        try {
            InputStreamReader fileIn = new InputStreamReader(SekCPhysics.class.getResourceAsStream("/assets/sekcphysics/ragdolldata/" + modid + ".json"));
            Gson jsonFile = new Gson();
            JsonObject ragdollFileJson = (JsonObject)jsonFile.fromJson((Reader)fileIn, JsonObject.class);
            Set entityEnteries = ragdollFileJson.entrySet();
            ProgressManager.ProgressBar bar = ProgressManager.push((String)"Constructing", (int)entityEnteries.size());
            for (Map.Entry entry : entityEnteries) {
                bar.step((String)entry.getKey());
                try {
                    RagdollData ragdollData = new RagdollData();
                    this.addRagdollSkeletonPointData(((JsonElement)entry.getValue()).getAsJsonObject(), ragdollData, ragdollFileJson);
                    this.applyModifiers(((JsonElement)entry.getValue()).getAsJsonObject(), ragdollData, ragdollFileJson);
                    this.addRagdollConstraintData(((JsonElement)entry.getValue()).getAsJsonObject(), ragdollData, ragdollFileJson);
                    this.addRagdollTrackerData(((JsonElement)entry.getValue()).getAsJsonObject(), ragdollData, ragdollFileJson);
                    this.addRagdollOtherData(((JsonElement)entry.getValue()).getAsJsonObject(), ragdollData, ragdollFileJson);
                    ModelConstructData modelConstructData = this.getRagdollModelData(((JsonElement)entry.getValue()).getAsJsonObject(), ragdollFileJson);
                    ModelData modelData = this.createModelAndAddTrackers(ragdollData, modelConstructData);
                    ragdollData.addModelData(modelData);
                    if (SekCPhysics.isDeObf || !((JsonElement)entry.getValue()).getAsJsonObject().has("entityObf")) {
                        SekCPhysics.ragdolls.registerRagdoll((String)entry.getKey(), ragdollData);
                        continue;
                    }
                    SekCPhysics.ragdolls.registerRagdoll(((JsonElement)entry.getValue()).getAsJsonObject().get("entityObf").getAsString(), ragdollData);
                }
                catch (RagdollInvalidDataException | ClassCastException | IllegalStateException | UnsupportedOperationException e) {
                    SekCPhysics.logger.error("Invalid data for: " + (String)entry.getKey());
                    SekCPhysics.logger.error("Error message: " + e.getMessage());
                    SekCPhysics.logger.catching(Level.ERROR, (Throwable)e);
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
            SekCPhysics.logger.info("Data loaded for: " + modid);
        }
        catch (JsonSyntaxException | UnsupportedOperationException e) {
            SekCPhysics.logger.info("Error with data for: " + modid);
            SekCPhysics.logger.catching(Level.ERROR, e);
        }
        catch (JsonIOException | NullPointerException e) {
            SekCPhysics.logger.info("No ragdoll data found for: " + modid);
        }
    }

    private void applyModifiers(JsonObject ragdollJsonData, RagdollData ragdollData, JsonObject ragdollFileJson) {
        for (Map.Entry<String, PointD> entry : ragdollData.getPointMap().entrySet()) {
            PointD point = entry.getValue();
            ragdollData.setSkeletonPoint(entry.getKey(), point.x * (double)ragdollData.getScale(), point.y * (double)ragdollData.getScale(), point.z * (double)ragdollData.getScale());
        }
    }

    private void addRagdollSkeletonPointData(JsonObject ragdollJsonData, RagdollData ragdollData, JsonObject ragdollFileJson) throws UnsupportedOperationException, RagdollInvalidDataException {
        JsonElement scaleValue;
        JsonObject skeletonPoints;
        JsonElement inherit = this.getInheritData(ragdollJsonData, ragdollFileJson);
        if (inherit != null) {
            this.addRagdollSkeletonPointData(inherit.getAsJsonObject(), ragdollData, ragdollFileJson);
        }
        if ((skeletonPoints = ragdollJsonData.getAsJsonObject("skeletonPoints")) != null) {
            for (Map.Entry pointName : skeletonPoints.entrySet()) {
                JsonArray pointPosArray = skeletonPoints.get((String)pointName.getKey()).getAsJsonArray();
                ragdollData.setSkeletonPoint((String)pointName.getKey(), pointPosArray.get(0).getAsDouble(), pointPosArray.get(1).getAsDouble(), pointPosArray.get(2).getAsDouble());
            }
        } else if (ragdollData.getPointMap().size() == 0) {
            throw new RagdollInvalidDataException("No skeleton points");
        }
        if ((scaleValue = ragdollJsonData.get("entityScale")) != null) {
            ragdollData.setScale(scaleValue.getAsFloat());
        }
    }

    private void addRagdollConstraintData(JsonObject ragdollJsonData, RagdollData ragdollData, JsonObject ragdollFileJson) throws UnsupportedOperationException, RagdollInvalidDataException {
        JsonArray constraints;
        JsonElement inherit = this.getInheritData(ragdollJsonData, ragdollFileJson);
        if (inherit != null) {
            this.addRagdollConstraintData(inherit.getAsJsonObject(), ragdollData, ragdollFileJson);
        }
        if ((constraints = ragdollJsonData.getAsJsonArray("constraints")) != null) {
            for (JsonElement constraintEle : constraints) {
                JsonArray constraint = constraintEle.getAsJsonArray();
                ragdollData.addConstraint(constraint.get(0).getAsString(), constraint.get(1).getAsString());
            }
        } else if (ragdollData.getConstraints().length == 0) {
            throw new RagdollInvalidDataException("No constraints");
        }
    }

    private void addRagdollTrackerData(JsonObject ragdollJsonData, RagdollData ragdollData, JsonObject ragdollFileJson) throws UnsupportedOperationException, RagdollInvalidDataException {
        JsonObject triangleJSON;
        JsonElement inherit = this.getInheritData(ragdollJsonData, ragdollFileJson);
        if (inherit != null) {
            this.addRagdollTrackerData(inherit.getAsJsonObject(), ragdollData, ragdollFileJson);
        }
        if ((triangleJSON = ragdollJsonData.getAsJsonObject("triangles")) != null) {
            Set triangleNames = triangleJSON.entrySet();
            for (Map.Entry triangleName : triangleNames) {
                JsonArray pointPosArray = triangleJSON.get((String)triangleName.getKey()).getAsJsonArray();
                ragdollData.addTriangle((String)triangleName.getKey(), pointPosArray.get(0).getAsString(), pointPosArray.get(1).getAsString(), pointPosArray.get(2).getAsString());
            }
        }
    }

    private void addRagdollOtherData(JsonObject ragdollJsonData, RagdollData ragdollData, JsonObject ragdollFileJson) throws UnsupportedOperationException, RagdollInvalidDataException {
        JsonElement heightOffset;
        JsonElement inherit = this.getInheritData(ragdollJsonData, ragdollFileJson);
        if (inherit != null) {
            this.addRagdollOtherData(inherit.getAsJsonObject(), ragdollData, ragdollFileJson);
        }
        if ((heightOffset = ragdollJsonData.get("centerHeightOffset")) != null) {
            ragdollData.setCenterHeightOffset(heightOffset.getAsFloat() * ragdollData.getScale());
        }
    }

    private ModelConstructData getRagdollModelData(JsonObject ragdollJsonData, JsonObject ragdollFileJson) throws UnsupportedOperationException, RagdollInvalidDataException {
        JsonObject modelJSON;
        JsonElement inherit = this.getInheritData(ragdollJsonData, ragdollFileJson);
        ModelConstructData modelConstructData = inherit != null ? this.getRagdollModelData(inherit.getAsJsonObject(), ragdollFileJson) : new ModelConstructData();
        JsonElement textureEle = ragdollJsonData.get("texture");
        if (textureEle != null) {
            JsonArray texture = textureEle.getAsJsonArray();
            modelConstructData.setTextureDomain(texture.get(0).getAsString(), texture.get(1).getAsString());
        }
        if ((modelJSON = ragdollJsonData.getAsJsonObject("modelData")) != null) {
            JsonObject triangleTrackers;
            TrackerData trackerData;
            JsonObject vertexTrackers;
            if (SekCPhysics.isDeObf || !modelJSON.has("classObf")) {
                modelConstructData.setClassName(modelJSON.get("class").getAsString());
            } else {
                modelConstructData.setClassName(modelJSON.get("classObf").getAsString());
            }
            modelConstructData.setClassName(modelJSON.get("class").getAsString());
            JsonArray constructData = modelJSON.getAsJsonArray("constructData");
            if (constructData != null) {
                Object[] constructObjects = new Object[constructData.size()];
                for (int i = 0; i < constructObjects.length; ++i) {
                    JsonArray entry = constructData.get(i).getAsJsonArray();
                    String type = entry.get(0).getAsString();
                    Object data = null;
                    JsonElement dataEle = entry.get(1);
                    switch (type) {
                        case "double": {
                            data = dataEle.getAsDouble();
                            break;
                        }
                        case "float": {
                            data = Float.valueOf(dataEle.getAsFloat());
                            break;
                        }
                        case "int": {
                            data = dataEle.getAsInt();
                            break;
                        }
                        case "long": {
                            data = dataEle.getAsLong();
                            break;
                        }
                        case "boolean": {
                            data = dataEle.getAsBoolean();
                            break;
                        }
                        case "String": {
                            data = dataEle.getAsString();
                            break;
                        }
                        default: {
                            throw new RagdollInvalidDataException("Invalid Construct Data Type: " + type);
                        }
                    }
                    constructObjects[i] = data;
                }
                modelConstructData.setConstructData(constructObjects);
            }
            if ((vertexTrackers = modelJSON.getAsJsonObject("vertexTrackers")) != null) {
                Set vertexNames = vertexTrackers.entrySet();
                for (Map.Entry vertexName : vertexNames) {
                    JsonObject vertexObj = ((JsonElement)vertexName.getValue()).getAsJsonObject();
                    String anchor = vertexObj.get("anchor").getAsString();
                    String pointTo = vertexObj.get("pointTo").getAsString();
                    String name = SekCPhysics.isDeObf || !vertexObj.has("obfName") ? (String)vertexName.getKey() : vertexObj.get("obfName").getAsString();
                    trackerData = new VertexTrackerData(name, anchor, pointTo, vertexObj);
                    modelConstructData.addVertexTracker((VertexTrackerData)trackerData);
                }
            }
            if ((triangleTrackers = modelJSON.getAsJsonObject("triangleTrackers")) != null) {
                Set triangleNames = triangleTrackers.entrySet();
                for (Map.Entry triangleName : triangleNames) {
                    JsonObject vertexObj = ((JsonElement)triangleName.getValue()).getAsJsonObject();
                    String tracker = vertexObj.get("tracker").getAsString();
                    String name = SekCPhysics.isDeObf || !vertexObj.has("obfName") ? (String)triangleName.getKey() : vertexObj.get("obfName").getAsString();
                    trackerData = new TriangleTrackerData(name, tracker, vertexObj);
                    modelConstructData.addTriangleTracker((TriangleTrackerData)trackerData);
                }
            }
        }
        return modelConstructData;
    }

    private ModelData createModelAndAddTrackers(RagdollData ragdollData, ModelConstructData modelConstructData) throws RagdollInvalidDataException {
        if (modelConstructData.getClassName() == null) {
            throw new RagdollInvalidDataException("Model class was not given");
        }
        try {
            TriangleTrackerData[] triangleTrackers;
            VertexTrackerData[] vertexTrackers;
            Class<?> rClass = Class.forName(modelConstructData.getClassName());
            if (ModelBase.class.isInstance(rClass)) {
                throw new RagdollInvalidDataException("Invalid model class");
            }
            Object[] constructObjects = modelConstructData.getConstructData();
            Class[] classArray = new Class[constructObjects.length];
            for (int i = 0; i < constructObjects.length; ++i) {
                Class classType = constructObjects[i].getClass();
                try {
                    Object tempClassObj = classType.getField("TYPE").get(null);
                    if (tempClassObj instanceof Class) {
                        classType = (Class)tempClassObj;
                    }
                }
                catch (NoSuchFieldException e) {
                    SekCPhysics.logger.info("Constructor non primitive.");
                }
                classArray[i] = classType;
            }
            ModelBase modelBase = (ModelBase)rClass.getConstructor(classArray).newInstance(constructObjects);
            ModelData modelData = new ModelData(modelBase);
            this.addExtraModelData(ragdollData, modelData, modelConstructData);
            for (VertexTrackerData vertexData : vertexTrackers = modelConstructData.getVertexTrackerData()) {
                ModelRenderer renderer = this.getRendererFromName(vertexData.getPartName(), modelBase, rClass);
                vertexData.setPart(renderer);
            }
            modelData.setVertexTrackers(vertexTrackers);
            for (TriangleTrackerData triangleData : triangleTrackers = modelConstructData.getTriangleTrackerData()) {
                ModelRenderer renderer = this.getRendererFromName(triangleData.getPartName(), modelBase, rClass);
                triangleData.setPart(renderer);
            }
            modelData.setTriangleTrackers(triangleTrackers);
            return modelData;
        }
        catch (ClassNotFoundException e) {
            SekCPhysics.logger.error("Could not find specified class" + modelConstructData.getClassName());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            SekCPhysics.logger.error("Illegal access");
            e.printStackTrace();
        }
        catch (InstantiationException | InvocationTargetException e) {
            SekCPhysics.logger.error("Construction error");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            SekCPhysics.logger.error("Method not found, invalid class of construction data listed");
            e.printStackTrace();
        }
        catch (SecurityException e) {
            SekCPhysics.logger.error("The security manager has blocked access to the class" + modelConstructData.getClassName());
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            SekCPhysics.logger.error("Field not found for " + modelConstructData.getClassName());
            e.printStackTrace();
        }
        return null;
    }

    private void addExtraModelData(RagdollData ragdollData, ModelData modelData, ModelConstructData modelConstructData) {
        ResourceData textureDomain = modelConstructData.getTextureDomain();
        modelData.setTexture(new ResourceLocation(textureDomain.getTextureDomain(), textureDomain.getTexture()));
    }

    private ModelRenderer getRendererFromName(String partName, ModelBase modelBase, Class<?> rClass) throws NoSuchFieldException, RagdollInvalidDataException, IllegalAccessException {
        Field partRender = rClass.getField(partName);
        Object partObj = partRender.get(modelBase);
        if (partObj instanceof ModelRenderer) {
            return (ModelRenderer)partObj;
        }
        throw new RagdollInvalidDataException("Unexpected object type stored in location");
    }

    private JsonElement getInheritData(JsonObject enteryJson, JsonObject ragdollFileJson) {
        JsonElement inherit = enteryJson.get("inherit");
        if (inherit == null) {
            return null;
        }
        return ragdollFileJson.get(inherit.getAsString());
    }

    public void loadRagdolls() {
        SekCPhysics.logger.debug("Loading ragdolls and checking for supported mods");
        List modlist = Loader.instance().getActiveModList();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"SekCPhysics", (int)modlist.size());
        for (ModContainer mod : modlist) {
            bar.step("Processing " + mod.getModId());
            this.generateRagdollsFrom(mod.getModId());
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }
}

