/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.generation.data;

import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.ragdoll.generation.data.ConstraintData;
import com.sekwah.sekcphysics.ragdoll.generation.data.ModelData;
import com.sekwah.sekcphysics.ragdoll.generation.data.RagdollInvalidDataException;
import com.sekwah.sekcphysics.ragdoll.generation.data.TriangleData;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.util.ResourceLocation;

public class RagdollData {
    private HashMap<String, PointD> pointHashMap = new HashMap();
    private HashMap<String, TriangleData> triangleHashMap = new HashMap();
    private ModelBase ragdollModel;
    private ResourceLocation entityTexture;
    private LinkedList<ConstraintData> constraintLinkedList = new LinkedList();
    private HashMap<String, Triangle> trangleHashMap = new HashMap();
    private float centerHeightOffset;
    private ModelData modelData;
    private float scale = 1.0f;

    public void setSkeletonPoint(String pointName, double x, double y, double z) {
        this.pointHashMap.put(pointName, new PointD(x, y, z));
    }

    public void addConstraint(String point1, String point2) throws RagdollInvalidDataException {
        this.constraintLinkedList.add(new ConstraintData(this.checkPoint(point1), this.checkPoint(point2)));
    }

    public PointD getPoint(String point) throws RagdollInvalidDataException {
        PointD skeletonPoint = this.pointHashMap.get(point);
        if (skeletonPoint == null) {
            throw new RagdollInvalidDataException("Invalid Skeleton Point Selected");
        }
        return skeletonPoint;
    }

    public String checkPoint(String point) throws RagdollInvalidDataException {
        if (!this.pointHashMap.containsKey(point)) {
            throw new RagdollInvalidDataException("Invalid Skeleton Point Selected");
        }
        return point;
    }

    public PointD[] getPoints() {
        return this.pointHashMap.values().toArray(new PointD[0]);
    }

    public ConstraintData[] getConstraints() {
        return this.constraintLinkedList.toArray(new ConstraintData[0]);
    }

    public HashMap<String, PointD> getPointMap() {
        return this.pointHashMap;
    }

    public void addTriangle(String name, String point1, String point2, String point3) throws RagdollInvalidDataException {
        if (this.triangleHashMap.containsKey(name)) {
            throw new RagdollInvalidDataException("Already triangle with that name");
        }
        this.triangleHashMap.put(name, new TriangleData(point1, point2, point3));
    }

    public TriangleData[] getTriangles() {
        return this.triangleHashMap.values().toArray(new TriangleData[0]);
    }

    public HashMap<String, TriangleData> getTriangleMap() {
        return this.triangleHashMap;
    }

    public void addModelData(ModelData modelData) {
        this.modelData = modelData;
    }

    public ModelData getModelData() {
        return this.modelData;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public float getCenterHeightOffset() {
        return this.centerHeightOffset;
    }

    public void setCenterHeightOffset(float centerHeightOffset) {
        this.centerHeightOffset = centerHeightOffset;
    }
}

