/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts;

import com.sekwah.sekcphysics.client.cliententity.EntityRagdoll;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.ragdoll.parts.SkeletonPoint;

public class Constraint {
    public double length;
    public SkeletonPoint[] end = new SkeletonPoint[2];

    public Constraint(SkeletonPoint start, SkeletonPoint end) {
        this.end[0] = start;
        this.end[1] = end;
        this.length = Math.sqrt(Math.pow(start.posX - end.posX, 2.0) + Math.pow(start.posY - end.posY, 2.0) + Math.pow(start.posZ - end.posZ, 2.0));
    }

    public void calc(EntityRagdoll entity) {
        if (!this.end[0].hasMoved && !this.end[1].hasMoved) {
            return;
        }
        PointD averageLoc = new PointD((this.end[0].newPosX + this.end[1].newPosX) * 0.5, (this.end[0].newPosY + this.end[1].newPosY) * 0.5, (this.end[0].newPosZ + this.end[1].newPosZ) * 0.5);
        double currentLength = Math.sqrt(Math.pow(this.end[0].newPosX - this.end[1].newPosX, 2.0) + Math.pow(this.end[0].newPosY - this.end[1].newPosY, 2.0) + Math.pow(this.end[0].newPosZ - this.end[1].newPosZ, 2.0));
        if (currentLength == this.length) {
            return;
        }
        if (currentLength == 0.0) {
            currentLength = 0.01;
        }
        double currentLengthInvert = 1.0 / currentLength;
        PointD direction = new PointD((this.end[0].newPosX - this.end[1].newPosX) * currentLengthInvert, (this.end[0].newPosY - this.end[1].newPosY) * currentLengthInvert, (this.end[0].newPosZ - this.end[1].newPosZ) * currentLengthInvert);
        double halfLength = this.length * 0.5;
        this.end[0].setNewPos(averageLoc.x + direction.x * halfLength, averageLoc.y + direction.y * halfLength, (float)(averageLoc.z + direction.z * halfLength));
        this.end[1].setNewPos(averageLoc.x - direction.x * halfLength, averageLoc.y - direction.y * halfLength, averageLoc.z - direction.z * halfLength);
    }
}

