/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts;

import com.sekwah.sekcphysics.client.cliententity.EntityRagdoll;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.ragdoll.Ragdolls;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class SkeletonPoint {
    private final float size;
    public double posX;
    public double posY;
    public double posZ;
    public double lastPosX;
    public double lastPosY;
    public double lastPosZ;
    public double newPosX;
    public double newPosY;
    public double newPosZ;
    private double nonMoveThresh = 0.001;
    public boolean hasMoved = true;
    public float pushability = 1.0f;
    public double velX = 0.0;
    public double velY = 0.0;
    public double velZ = 0.0;
    private boolean onGround = false;

    public SkeletonPoint(double x, double y, double z, float size) {
        this(x, y, z, size, true);
    }

    public SkeletonPoint(double x, double y, double z, boolean shouldDoModelScale) {
        this(x, y, z, 0.15f, shouldDoModelScale);
    }

    public SkeletonPoint(double x, double y, double z) {
        this(x, y, z, 0.15f, true);
    }

    public SkeletonPoint(double x, double y, double z, float size, boolean shouldDoModelScale) {
        this.setPosition(x, y, z);
        float sizeRandom = (float)Math.random();
        float maxOffset = 0.001f;
        this.size = size += -maxOffset + maxOffset * 2.0f * sizeRandom;
        if (shouldDoModelScale) {
            this.shiftPositionToModelScale();
        }
    }

    public void shiftPositionToModelScale() {
        this.setPosition(this.posX / 16.0, this.posY / 16.0, this.posZ / 16.0);
    }

    public void shiftPositionToWorldScale() {
        this.setPosition(this.posX * 16.0, this.posY * 16.0, this.posZ * 16.0);
    }

    public void setPosition(double x, double y, double z) {
        this.newPosX = this.posX = x;
        this.lastPosX = this.posX;
        this.newPosY = this.posY = y;
        this.lastPosY = this.posY;
        this.newPosZ = this.posZ = z;
        this.lastPosZ = this.posZ;
        this.checkWillMove();
    }

    public void movePoint(EntityRagdoll entity, double moveX, double moveY, double moveZ) {
        int k;
        double pointPosX = entity.field_70165_t + this.posX;
        double pointPosY = entity.field_70163_u + this.posY;
        double pointPosZ = entity.field_70161_v + this.posZ;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pointPosX - (double)this.size, pointPosY - (double)this.size, pointPosZ - (double)this.size, pointPosX + (double)this.size, pointPosY + (double)this.size, pointPosZ + (double)this.size);
        List list = entity.field_70170_p.func_184144_a((Entity)entity, axisalignedbb.func_72321_a(moveX, moveY, moveZ));
        double oMoveY = moveY;
        for (k = 0; k < list.size(); ++k) {
            moveY = ((AxisAlignedBB)list.get(k)).func_72323_b(axisalignedbb, moveY);
        }
        if (oMoveY < 0.0 && moveY != oMoveY) {
            this.onGround = true;
        }
        axisalignedbb = axisalignedbb.func_72317_d(0.0, moveY, 0.0);
        for (k = 0; k < list.size(); ++k) {
            moveX = ((AxisAlignedBB)list.get(k)).func_72316_a(axisalignedbb, moveX);
        }
        axisalignedbb = axisalignedbb.func_72317_d(moveX, 0.0, 0.0);
        for (k = 0; k < list.size(); ++k) {
            moveZ = ((AxisAlignedBB)list.get(k)).func_72322_c(axisalignedbb, moveZ);
        }
        axisalignedbb = axisalignedbb.func_72317_d(0.0, 0.0, moveZ);
        this.posX = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0 - entity.field_70165_t;
        this.posY = (axisalignedbb.field_72338_b + axisalignedbb.field_72337_e) / 2.0 - entity.field_70163_u;
        this.posZ = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0 - entity.field_70161_v;
        this.checkWillMove();
    }

    private boolean checkWillMove() {
        boolean moved;
        this.nonMoveThresh = 1.0E-4f;
        double move = this.newPosX - this.posX + this.newPosY - this.posY + this.newPosZ - this.posZ;
        boolean bl = moved = Math.abs(move) < this.nonMoveThresh;
        if (!moved) {
            this.newPosX = this.posX;
            this.newPosY = this.posY;
            this.newPosZ = this.posZ;
        }
        this.hasMoved = moved;
        return this.hasMoved;
    }

    private boolean isAboveSpeedThreashold(double vel) {
        return Math.abs(vel) > this.nonMoveThresh;
    }

    public void update(EntityRagdoll entity) {
        this.velX = this.posX - this.lastPosX;
        if (!this.isAboveSpeedThreashold(this.velX)) {
            this.velX = 0.0;
        }
        this.velY = this.posY - this.lastPosY;
        if (!this.isAboveSpeedThreashold(this.velX)) {
            this.velX = 0.0;
        }
        this.velZ = this.posZ - this.lastPosZ;
        if (!this.isAboveSpeedThreashold(this.velX)) {
            this.velX = 0.0;
        }
        float speedMulti = 0.9999f;
        this.velY *= (double)speedMulti;
        if (this.onGround) {
            float groundMulti = 0.85f;
            this.velX *= (double)groundMulti;
            this.velZ *= (double)groundMulti;
        } else {
            this.velX *= (double)speedMulti;
            this.velZ *= (double)speedMulti;
        }
        this.onGround = false;
        this.lastPosX = this.posX;
        this.lastPosY = this.posY;
        this.lastPosZ = this.posZ;
        double pointPosX = entity.field_70165_t + this.posX;
        double pointPosY = entity.field_70163_u + this.posY;
        double pointPosZ = entity.field_70161_v + this.posZ;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pointPosX - (double)this.size, pointPosY - (double)this.size, pointPosZ - (double)this.size, pointPosX + (double)this.size, pointPosY + (double)this.size, pointPosZ + (double)this.size);
        if (entity.field_70170_p.func_72918_a(axisalignedbb.func_72321_a(0.0, (double)-0.4f, 0.0).func_191195_a(0.001, 0.001, 0.001), Material.field_151586_h, (Entity)entity)) {
            this.addVelocity(0.0, 0.1f, 0.0);
            if (this.posY - this.lastPosY > 0.5) {
                this.lastPosY = this.posY - 0.5;
            }
        }
        this.updateCollisions(entity);
        this.movePoint(entity, this.velX, this.velY - (double)Ragdolls.gravity, this.velZ);
        if (this.checkWillMove()) {
            this.newPosX = this.posX;
            this.newPosY = this.posY;
            this.newPosZ = this.posZ;
        }
    }

    private void updateCollisions(EntityRagdoll entity) {
        double pointPosX = entity.field_70165_t + this.posX;
        double pointPosY = entity.field_70163_u + this.posY;
        double pointPosZ = entity.field_70161_v + this.posZ;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pointPosX - (double)this.size, pointPosY - (double)this.size, pointPosZ - (double)this.size, pointPosX + (double)this.size, pointPosY + (double)this.size, pointPosZ + (double)this.size);
        List list = entity.field_70170_p.func_72839_b((Entity)entity, axisalignedbb.func_72321_a((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entityCol = (Entity)list.get(i);
                if (!entityCol.func_70104_M()) continue;
                this.collideWithEntity(entity, entityCol);
            }
        }
        this.checkWillMove();
    }

    private void collideWithEntity(EntityRagdoll entity, Entity entityCol) {
        double pointPosX = entity.field_70165_t + this.posX;
        double d0 = pointPosX - entityCol.field_70165_t;
        double pointPosZ = entity.field_70161_v + this.posZ;
        double d1 = pointPosZ - entityCol.field_70161_v;
        double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
        if (d2 >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            this.addVelocity((d0 *= (double)(1.0f - entityCol.field_70144_Y)) + entityCol.field_70159_w, 0.0, (d1 *= (double)(1.0f - entityCol.field_70144_Y)) + entityCol.field_70179_y);
        }
    }

    public void setNewPos(double x, double y, double z) {
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
    }

    public void updatePos(EntityRagdoll entity) {
        this.moveTo(entity, this.newPosX, this.newPosY, this.newPosZ);
    }

    public void moveTo(EntityRagdoll entity, double x, double y, double z) {
        this.movePoint(entity, x - this.posX, y - this.posY, z - this.posZ);
    }

    public PointD toPoint() {
        return new PointD(this.posX, this.posY, this.posZ);
    }

    public void verify(EntityRagdoll entity) {
        double tempPosX = this.posX;
        double tempPosY = this.posY;
        double tempPosZ = this.posZ;
        this.posX = 0.0;
        this.posY = 0.0;
        this.posZ = 0.0;
        this.moveTo(entity, tempPosX, tempPosY, tempPosZ);
        this.lastPosX = this.posX;
        this.lastPosY = this.posY;
        this.lastPosZ = this.posZ;
    }

    public void shiftPosition(double x, double y, double z) {
        this.posX += x;
        this.posY += y;
        this.posZ += z;
        this.lastPosX += x;
        this.lastPosY += y;
        this.lastPosZ += z;
    }

    public void setVelocity(double motionX, double motionY, double motionZ) {
        this.lastPosX = this.posX - motionX;
        this.lastPosY = this.posY - motionY;
        this.lastPosZ = this.posZ - motionZ;
    }

    public void addVelocity(double motionX, double motionY, double motionZ) {
        this.lastPosX -= motionX;
        this.lastPosY -= motionY;
        this.lastPosZ -= motionZ;
    }

    public void setNewPos(PointD newLoc) {
        this.setNewPos(newLoc.x, newLoc.y, newLoc.z);
    }

    public void setPosition(PointD newLoc) {
        this.setPosition(newLoc.x, newLoc.y, newLoc.z);
    }
}

