/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts;

import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.maths.VectorMaths;
import com.sekwah.sekcphysics.ragdoll.parts.SkeletonPoint;

public class Triangle {
    public SkeletonPoint[] points = new SkeletonPoint[3];

    public Triangle(SkeletonPoint pos1, SkeletonPoint pos2, SkeletonPoint pos3) {
        this.points[0] = pos1;
        this.points[1] = pos2;
        this.points[2] = pos3;
    }

    public void calcRotation() {
        PointD up = this.normalize(this.points[1].toPoint(), this.points[0].toPoint());
        PointD right = this.subtract(this.points[2].toPoint(), this.points[0].toPoint());
        PointD facing = this.normalize(new PointD(0.0, 0.0, 0.0), this.crossProduct(up, right));
        right = this.normalize(new PointD(0.0, 0.0, 0.0), this.crossProduct(facing, right));
    }

    private PointD crossProduct(PointD point1, PointD point2) {
        double posX = point1.y * point2.z - point1.z * point2.y;
        double posY = point1.z * point2.x - point1.x * point2.z;
        double posZ = point1.x * point2.y - point1.y * point2.x;
        return new PointD(posX, posY, posZ);
    }

    private PointD subtract(PointD point1, PointD point2) {
        return new PointD(point1.x - point2.x, point1.y - point2.z, point1.z - point2.z);
    }

    private PointD normalize(PointD point1, PointD point2) {
        double currentLength = Math.sqrt(Math.pow(point1.x - point2.x, 2.0) + Math.pow(point1.y - point2.y, 2.0) + Math.pow(point1.z - point2.z, 2.0));
        return new PointD((point1.x - point2.x) / (double)((float)currentLength), (point1.y - point2.y) / (double)((float)currentLength), (point1.z - point2.z) / (double)((float)currentLength));
    }

    public PointD getDirectionNorm() {
        PointD averageLoc = new PointD((this.points[1].posX + this.points[2].posX) / 2.0, (this.points[1].posY + this.points[2].posY) / 2.0, (this.points[1].posZ + this.points[2].posZ) / 2.0);
        double currentLength = Math.sqrt(Math.pow(this.points[0].posX - averageLoc.x, 2.0) + Math.pow(this.points[0].posY - averageLoc.y, 2.0) + Math.pow(this.points[0].posZ - averageLoc.z, 2.0));
        PointD direction = new PointD((averageLoc.x - this.points[0].posX) / (double)((float)currentLength), (averageLoc.y - this.points[0].posY) / (double)((float)currentLength), (averageLoc.z - this.points[0].posZ) / (double)((float)currentLength));
        return direction;
    }

    public PointD getDirection() {
        PointD averageLoc = new PointD((this.points[1].posX + this.points[2].posX) / 2.0, (this.points[1].posY + this.points[2].posY) / 2.0, (this.points[1].posZ + this.points[2].posZ) / 2.0);
        PointD direction = new PointD(averageLoc.x - this.points[0].posX, averageLoc.y - this.points[0].posY, averageLoc.z - this.points[0].posZ);
        return direction;
    }

    public float getAngle() {
        return 0.0f;
    }

    public PointD getNormal() {
        return VectorMaths.getTriangleNormal(this.points[0].toPoint(), this.points[1].toPoint(), this.points[2].toPoint());
    }
}

