/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts.trackers;

import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.maths.RotateF;
import net.minecraft.client.model.ModelRenderer;

public abstract class Tracker {
    protected final ModelRenderer part;
    public ModelRenderer bodyPart = null;
    public RotateF rotationOffset = new RotateF();
    public RotateF rotation = new RotateF();
    public RotateF rotationDiff = new RotateF();
    public RotateF lastRotation = new RotateF();
    public PointD position = new PointD();
    public PointD lastPosition = new PointD();
    public PointD positionDiff = new PointD();
    public RotateF distToLastRotation = new RotateF();
    public PointD offset = new PointD();

    protected Tracker(ModelRenderer part) {
        this.part = part;
    }

    public Tracker(ModelRenderer part, float rotateOffsetX, float rotateOffsetY, float rotateOffsetZ) {
        this(part);
        this.rotationOffset = new RotateF(rotateOffsetX, rotateOffsetY, rotateOffsetZ);
    }

    public void render() {
        this.render(1.0f);
    }

    protected void renderPart(float partialTicks) {
        this.renderPart(partialTicks, 0.0625f);
    }

    protected void renderPart(float partialTicks, float scale) {
        this.setPartLocation(partialTicks);
        this.setPartRotation(partialTicks);
        this.part.func_78785_a(scale);
    }

    protected void updateLastPos() {
        this.lastRotation.copy(this.rotation);
        this.lastPosition = this.position;
    }

    public void updatePosDifference() {
        this.rotationDiff.copy(this.rotation).sub(this.lastRotation);
        this.positionDiff = this.position.sub(this.lastPosition);
        this.rotationDiff.changeToShortestAngle();
        this.lastRotation.add(this.rotationOffset);
        this.lastPosition = this.lastPosition.add(this.offset);
    }

    public abstract void calcPosition();

    public void setPartLocation(float partialTicks) {
        this.part.func_78793_a((float)(this.lastPosition.x + this.positionDiff.x * (double)partialTicks) * 16.0f, (float)(this.lastPosition.y + this.positionDiff.y * (double)partialTicks) * 16.0f, (float)(this.lastPosition.z + this.positionDiff.z * (double)partialTicks) * 16.0f);
    }

    public void setPartRotation(float partialTicks) {
        this.part.field_78795_f = this.lastRotation.x + this.rotationDiff.x * partialTicks;
        this.part.field_78796_g = this.lastRotation.y + this.rotationDiff.y * partialTicks;
        this.part.field_78808_h = this.lastRotation.z + this.rotationDiff.z * partialTicks;
    }

    public abstract void render(float var1);
}

