/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts.trackers;

import com.sekwah.sekcphysics.maths.MatrixMaths;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.maths.VectorMaths;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.Tracker;
import net.minecraft.client.model.ModelRenderer;

public class TrackerTriangle
extends Tracker {
    protected final Triangle triangle;

    public TrackerTriangle(ModelRenderer part, Triangle triangle) {
        super(part);
        this.triangle = triangle;
        this.calcPosition();
        this.updateLastPos();
        this.updatePosDifference();
    }

    public TrackerTriangle(ModelRenderer part, Triangle triangle, float rotateOffsetX, float rotateOffsetY, float rotateOffsetZ) {
        super(part, rotateOffsetX, rotateOffsetY, rotateOffsetZ);
        this.triangle = triangle;
    }

    @Override
    public void render(float partialTicks) {
        this.renderPart(partialTicks);
    }

    @Override
    public void calcPosition() {
        this.updateLastPos();
        PointD triangleDir = this.triangle.getDirection();
        PointD triangleNorm = this.triangle.getNormal();
        this.rotation.y = this.basicRotation(triangleDir.x, triangleDir.z);
        this.rotation.x = 1.5707964f + this.basicRotation(-triangleDir.y, (float)Math.sqrt(triangleDir.x * triangleDir.x + triangleDir.z * triangleDir.z));
        PointD angleDifference = VectorMaths.rotateOriginY(-this.rotation.y, triangleNorm);
        angleDifference = VectorMaths.rotateOriginX(-this.rotation.x, angleDifference);
        PointD rotations = MatrixMaths.addRotAroundAxis(this.rotation.x, this.rotation.y, 0.0, this.basicRotation(angleDifference.x, angleDifference.z));
        this.rotation.x = (float)rotations.x;
        this.rotation.y = (float)rotations.y;
        this.rotation.z = (float)rotations.z;
        this.updatePosition();
        this.updatePosDifference();
    }

    protected void updatePosition() {
        this.position = new PointD(this.triangle.points[0].posX, this.triangle.points[0].posY, this.triangle.points[0].posZ);
    }

    public float basicRotation(double axis1, double axis2) {
        return (float)Math.atan2(axis1, axis2);
    }
}

