/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.ragdolls;

import com.sekwah.sekcphysics.client.cliententity.EntityRagdoll;
import com.sekwah.sekcphysics.ragdoll.parts.Skeleton;
import com.sekwah.sekcphysics.ragdoll.parts.SkeletonPoint;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.Tracker;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerTriangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerTriangleScaled;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerVertex;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerVertexScaled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class BaseRagdoll {
    public final ModelBase baseModel;
    public Map<ModelRenderer, Tracker> trackerHashmap = new HashMap<ModelRenderer, Tracker>();
    public boolean trackersRegistered = false;
    public Skeleton skeleton;
    public double centerHeightOffset;
    public ResourceLocation resourceLocation;

    public BaseRagdoll(float centerHeightOffset, ModelBase baseModel) {
        this.baseModel = baseModel;
        this.skeleton = new Skeleton();
        this.centerHeightOffset = centerHeightOffset;
    }

    public void rotateRagdoll(float rotYaw) {
        this.skeleton.rotate(rotYaw);
    }

    public void update(EntityRagdoll entity) {
        this.skeleton.update(entity);
    }

    public void shiftPos(double x, double y, double z) {
        this.skeleton.shiftPos(x, y, z);
    }

    public void setStanceToEntity(EntityLivingBase entity) {
        for (SkeletonPoint point : this.skeleton.points) {
            Vec3d vec = new Vec3d(point.posX, point.posY, point.posZ);
            vec.func_178785_b((float)Math.toRadians(-entity.field_70177_z));
            point.setPosition(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
    }

    public void initTrackers(ModelBase model) {
        this.trackersRegistered = true;
    }

    protected void addVertexTracker(ModelRenderer part, SkeletonPoint anchor, SkeletonPoint pointTo, float scale) {
        if (scale == 1.0f) {
            this.trackerHashmap.put(part, new TrackerVertex(part, anchor, pointTo));
        } else {
            this.trackerHashmap.put(part, new TrackerVertexScaled(part, anchor, pointTo, scale));
        }
    }

    protected void addTriangleTracker(ModelRenderer part, Triangle triangle, float scale) {
        if (scale == 1.0f) {
            this.trackerHashmap.put(part, new TrackerTriangle(part, triangle));
        } else {
            this.trackerHashmap.put(part, new TrackerTriangleScaled(part, triangle, scale));
        }
    }

    protected void addTriangleTracker(ModelRenderer part, Triangle triangle, float rotateOffsetX, float rotateOffsetY, float rotateOffsetZ, float scale) {
        if (scale == 1.0f) {
            this.trackerHashmap.put(part, new TrackerTriangle(part, triangle, rotateOffsetX, rotateOffsetY, rotateOffsetZ));
        } else {
            this.trackerHashmap.put(part, new TrackerTriangleScaled(part, triangle, rotateOffsetX, rotateOffsetY, rotateOffsetZ, scale));
        }
    }

    public boolean isActive() {
        return this.skeleton.isActive();
    }

    public int activeStatus() {
        if (this.isActive()) {
            return 0;
        }
        return this.skeleton.updateCount == 1 ? 2 : 1;
    }
}

