/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts;

import com.sekwah.sekcphysics.client.cliententity.RagdollEntity;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.maths.VectorMaths;
import com.sekwah.sekcphysics.ragdoll.parts.Constraint;
import com.sekwah.sekcphysics.ragdoll.parts.SkeletonPoint;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.Tracker;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class Skeleton {
    public List<SkeletonPoint> points = new ArrayList<SkeletonPoint>();
    public List<Constraint> constraints = new ArrayList<Constraint>();
    public List<Triangle> triangles = new ArrayList<Triangle>();
    public int maxUpdateCount = 5;
    public int updateCount = 0;

    public boolean isActive() {
        for (SkeletonPoint point : this.points) {
            if (!point.hasMoved) continue;
            return true;
        }
        return false;
    }

    public void update(RagdollEntity entity) {
        this.storeTemp(entity);
        for (SkeletonPoint point : this.points) {
            point.update(entity);
        }
        int updates = 0;
        while (updates++ <= this.maxUpdateCount && this.isActive()) {
            for (Constraint constraint : this.constraints) {
                constraint.calc(entity);
            }
        }
        this.updateCount = updates;
        for (SkeletonPoint point : this.points) {
            point.updatePos(entity);
        }
        for (Tracker tracker : entity.ragdoll.trackerHashmap.values()) {
            tracker.calcPosition();
        }
        this.loadTemp(entity);
    }

    private void storeTemp(RagdollEntity entity) {
        entity.field_5960 = false;
        entity.tempPosX = entity.field_5987;
        entity.tempPosY = entity.field_6010;
        entity.tempPosZ = entity.field_6035;
        entity.tempBoundingBox = entity.method_5829();
    }

    private void loadTemp(RagdollEntity entity) {
        entity.field_5960 = true;
        entity.field_5987 = entity.tempPosX;
        entity.field_6010 = entity.tempPosY;
        entity.field_6035 = entity.tempPosZ;
        entity.method_5857(entity.tempBoundingBox);
    }

    public void renderSkeletonDebug() {
        this.renderSkeletonDebug(0);
    }

    public void renderSkeletonDebug(int activeStatus) {
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2896);
        for (Triangle triangle : this.triangles) {
            switch (activeStatus) {
                case 0: {
                    GL11.glColor4f((float)0.0f, (float)0.8f, (float)0.1f, (float)0.5f);
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)0.8f, (float)0.6f, (float)0.0f, (float)0.5f);
                    break;
                }
                case 2: {
                    GL11.glColor4f((float)0.8f, (float)0.0f, (float)0.0f, (float)0.5f);
                }
            }
            this.drawTriangle(triangle.points[0], triangle.points[1], triangle.points[2]);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glEnable((int)2884);
        for (Constraint constraint : this.constraints) {
            switch (activeStatus) {
                case 0: {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.2f, (float)0.8f);
                    break;
                }
                case 1: {
                    GL11.glColor4f((float)1.0f, (float)0.7f, (float)0.0f, (float)0.5f);
                    break;
                }
                case 2: {
                    GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                }
            }
            this.drawLine(constraint.end[0], constraint.end[1]);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (Triangle triangle : this.triangles) {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            PointD direction = triangle.getDirection();
            PointD normal = triangle.getNormal();
            PointD basePoint = triangle.points[0].toPoint();
            PointD directionPoint = basePoint.add(direction);
            PointD normalPoint = basePoint.add(normal.multiply(4.0));
            this.drawLine(basePoint, directionPoint);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            this.drawLine(basePoint, normalPoint);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2896);
    }

    public void drawLine(SkeletonPoint point, SkeletonPoint point2) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)point.posX, (double)point.posY, (double)point.posZ);
        GL11.glVertex3d((double)point2.posX, (double)point2.posY, (double)point2.posZ);
        GL11.glEnd();
    }

    public void drawLine(PointD point, PointD point2) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)point.x, (double)point.y, (double)point.z);
        GL11.glVertex3d((double)point2.x, (double)point2.y, (double)point2.z);
        GL11.glEnd();
    }

    public void drawTriangle(SkeletonPoint point, SkeletonPoint point2, SkeletonPoint point3) {
        GL11.glBegin((int)4);
        GL11.glVertex3d((double)point.posX, (double)point.posY, (double)point.posZ);
        GL11.glVertex3d((double)point2.posX, (double)point2.posY, (double)point2.posZ);
        GL11.glVertex3d((double)point3.posX, (double)point3.posY, (double)point3.posZ);
        GL11.glEnd();
    }

    public void verifyPoints(RagdollEntity entity) {
        this.storeTemp(entity);
        for (SkeletonPoint point : this.points) {
            point.verify(entity);
        }
        for (Tracker tracker : entity.ragdoll.trackerHashmap.values()) {
            tracker.updateLastPos();
            tracker.updatePosDifference();
        }
        this.loadTemp(entity);
    }

    public void shiftPos(double x, double y, double z) {
        for (SkeletonPoint point : this.points) {
            point.shiftPosition(x, y, z);
        }
    }

    public void setVelocity(double motionX, double motionY, double motionZ) {
        for (SkeletonPoint point : this.points) {
            point.setVelocity(motionX, motionY, motionZ);
        }
    }

    public void addVelocity(double motionX, double motionY, double motionZ) {
        for (SkeletonPoint point : this.points) {
            point.addVelocity(motionX, motionY, motionZ);
        }
    }

    public void rotate(float rotYaw) {
        for (SkeletonPoint point : this.points) {
            PointD newLoc = VectorMaths.rotateOriginY(Math.toRadians(-rotYaw), point.toPoint());
            point.setPosition(newLoc);
        }
    }
}

