/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts;

import com.sekwah.sekcphysics.client.cliententity.RagdollEntity;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.ragdoll.Ragdolls;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3614;

public class SkeletonPoint {
    private final float size;
    public double posX;
    public double posY;
    public double posZ;
    public double lastPosX;
    public double lastPosY;
    public double lastPosZ;
    public double newPosX;
    public double newPosY;
    public double newPosZ;
    private double nonMoveThresh = 0.001;
    public boolean hasMoved = true;
    public float pushability = 1.0f;
    public double velX = 0.0;
    public double velY = 0.0;
    public double velZ = 0.0;
    private boolean onGround = false;
    private boolean inWater;

    public SkeletonPoint(double x, double y, double z, float size) {
        this(x, y, z, size, true);
    }

    public SkeletonPoint(double x, double y, double z, boolean shouldDoModelScale) {
        this(x, y, z, 0.15f, shouldDoModelScale);
    }

    public SkeletonPoint(double x, double y, double z) {
        this(x, y, z, 0.15f, true);
    }

    public SkeletonPoint(double x, double y, double z, float size, boolean shouldDoModelScale) {
        this.setPosition(x, y, z);
        float sizeRandom = (float)Math.random();
        float maxOffset = 0.001f;
        this.size = size += -maxOffset + maxOffset * 2.0f * sizeRandom;
        if (shouldDoModelScale) {
            this.shiftPositionToModelScale();
        }
    }

    public void shiftPositionToModelScale() {
        this.setPosition(this.posX / 16.0, this.posY / 16.0, this.posZ / 16.0);
    }

    public void shiftPositionToWorldScale() {
        this.setPosition(this.posX * 16.0, this.posY * 16.0, this.posZ * 16.0);
    }

    public void setPosition(double x, double y, double z) {
        this.newPosX = this.posX = x;
        this.lastPosX = this.posX;
        this.newPosY = this.posY = y;
        this.lastPosY = this.posY;
        this.newPosZ = this.posZ = z;
        this.lastPosZ = this.posZ;
        this.checkWillMove();
    }

    private void movePoint(RagdollEntity entity, class_243 moveVec) {
        double pointPosX = entity.tempPosX + this.posX;
        double pointPosY = entity.tempPosY + this.posY;
        double pointPosZ = entity.tempPosZ + this.posZ;
        entity.method_5857(new class_238(pointPosX - (double)this.size, pointPosY - (double)this.size, pointPosZ - (double)this.size, pointPosX + (double)this.size, pointPosY + (double)this.size, pointPosZ + (double)this.size));
        entity.method_5784(class_1313.field_6308, moveVec);
        class_238 boundingBox = entity.method_5829();
        this.posX = (boundingBox.field_1323 + boundingBox.field_1320) / 2.0 - entity.tempPosX;
        this.posY = (boundingBox.field_1322 + boundingBox.field_1325) / 2.0 - entity.tempPosY;
        this.posZ = (boundingBox.field_1321 + boundingBox.field_1324) / 2.0 - entity.tempPosZ;
        this.onGround = entity.field_5952 || Math.abs(this.lastPosY - this.posY) < (double)0.01f;
        this.checkWillMove();
    }

    private void applyMove(class_243 vec3d) {
        this.posX += vec3d.field_1352;
        this.posY += vec3d.field_1351;
        this.posZ += vec3d.field_1350;
    }

    private boolean checkWillMove() {
        boolean moved;
        this.nonMoveThresh = 1.0E-4f;
        double move = Math.abs(this.newPosX - this.posX) + Math.abs(this.newPosY - this.posY) + Math.abs(this.newPosZ - this.posZ);
        boolean bl = moved = move < this.nonMoveThresh;
        if (!moved) {
            this.newPosX = this.posX;
            this.newPosY = this.posY;
            this.newPosZ = this.posZ;
        }
        this.hasMoved = moved;
        return this.hasMoved;
    }

    private boolean isAboveSpeedThreashold(double vel) {
        return Math.abs(vel) > this.nonMoveThresh;
    }

    public void update(RagdollEntity entity) {
        this.velX = this.posX - this.lastPosX;
        if (!this.isAboveSpeedThreashold(this.velX)) {
            this.velX = 0.0;
        }
        this.velY = this.posY - this.lastPosY;
        if (!this.isAboveSpeedThreashold(this.velX)) {
            this.velX = 0.0;
        }
        this.velZ = this.posZ - this.lastPosZ;
        if (!this.isAboveSpeedThreashold(this.velX)) {
            this.velX = 0.0;
        }
        float speedMulti = 0.9999f;
        this.velY *= (double)speedMulti;
        if (this.onGround) {
            float groundMulti = 0.85f;
            this.velX *= (double)groundMulti;
            this.velZ *= (double)groundMulti;
        } else {
            this.velX *= (double)speedMulti;
            this.velZ *= (double)speedMulti;
        }
        this.onGround = false;
        this.lastPosX = this.posX;
        this.lastPosY = this.posY;
        this.lastPosZ = this.posZ;
        class_238 axisalignedbb = this.getBoundingBox(entity);
        this.velY -= (double)Ragdolls.gravity;
        if (entity.field_6002.method_8422(axisalignedbb.method_1009(0.0, (double)-0.4f, 0.0).method_1002(0.001, 0.001, 0.001), class_3614.field_15920)) {
            this.addVelocity(0.0, 0.06f, 0.0);
            if (!this.inWater) {
                this.inWater = true;
                this.velX *= (double)0.9f;
                this.velY *= 0.5;
                this.velZ *= (double)0.9f;
            } else {
                this.velX *= (double)0.9f;
                this.velY *= (double)0.85f;
                this.velZ *= (double)0.9f;
            }
        } else {
            this.inWater = false;
        }
        this.updateCollisions(entity);
        this.movePoint(entity, new class_243(this.velX, this.velY, this.velZ));
        if (this.checkWillMove()) {
            this.newPosX = this.posX;
            this.newPosY = this.posY;
            this.newPosZ = this.posZ;
        }
    }

    private class_238 getBoundingBox(RagdollEntity entity) {
        double pointPosX = entity.field_5987 + this.posX;
        double pointPosY = entity.field_6010 + this.posY;
        double pointPosZ = entity.field_6035 + this.posZ;
        return new class_238(pointPosX - (double)this.size, pointPosY - (double)this.size, pointPosZ - (double)this.size, pointPosX + (double)this.size, pointPosY + (double)this.size, pointPosZ + (double)this.size);
    }

    private void updateCollisions(RagdollEntity entity) {
        double pointPosX = entity.field_5987 + this.posX;
        double pointPosY = entity.field_6010 + this.posY;
        double pointPosZ = entity.field_6035 + this.posZ;
        class_238 boundingBox = new class_238(pointPosX - (double)this.size, pointPosY - (double)this.size, pointPosZ - (double)this.size, pointPosX + (double)this.size, pointPosY + (double)this.size, pointPosZ + (double)this.size);
        List list = entity.field_6002.method_8335((class_1297)entity, boundingBox.method_1009((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                class_1297 entityCol = (class_1297)list.get(i);
                if (!entityCol.method_5810()) continue;
                this.collideWithEntity(entity, entityCol);
            }
        }
        this.checkWillMove();
    }

    private void collideWithEntity(RagdollEntity entity, class_1297 entityCol) {
        double pointPosX = entity.field_5987 + this.posX;
        double d0 = pointPosX - entityCol.field_5987;
        double pointPosZ = entity.field_6035 + this.posZ;
        double d1 = pointPosZ - entityCol.field_6035;
        double d2 = class_3532.method_15391((double)d0, (double)d1);
        if (d2 >= (double)0.01f) {
            d2 = class_3532.method_15368((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            this.addVelocity((d0 *= (double)(1.0f - entityCol.field_5968)) + entityCol.method_18798().field_1352, 0.0, (d1 *= (double)(1.0f - entityCol.field_5968)) + entityCol.method_18798().field_1350);
        }
    }

    public void setNewPos(double x, double y, double z) {
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
    }

    public void updatePos(RagdollEntity entity) {
        this.moveTo(entity, this.newPosX, this.newPosY, this.newPosZ);
    }

    public void moveTo(RagdollEntity entity, double x, double y, double z) {
        this.movePoint(entity, new class_243(x - this.posX, y - this.posY, z - this.posZ));
    }

    public PointD toPoint() {
        return new PointD(this.posX, this.posY, this.posZ);
    }

    public void verify(RagdollEntity entity) {
        double tempPosX = this.posX;
        double tempPosY = this.posY;
        double tempPosZ = this.posZ;
        this.posX = 0.0;
        this.posY = 0.0;
        this.posZ = 0.0;
        this.moveTo(entity, tempPosX, tempPosY, tempPosZ);
        this.lastPosX = this.posX;
        this.lastPosY = this.posY;
        this.lastPosZ = this.posZ;
    }

    public void shiftPosition(double x, double y, double z) {
        this.posX += x;
        this.posY += y;
        this.posZ += z;
        this.lastPosX += x;
        this.lastPosY += y;
        this.lastPosZ += z;
    }

    public void setVelocity(double motionX, double motionY, double motionZ) {
        this.lastPosX = this.posX - motionX;
        this.lastPosY = this.posY - motionY;
        this.lastPosZ = this.posZ - motionZ;
    }

    public void addVelocity(double motionX, double motionY, double motionZ) {
        this.lastPosX -= motionX;
        this.lastPosY -= motionY;
        this.lastPosZ -= motionZ;
    }

    public void setNewPos(PointD newLoc) {
        this.setNewPos(newLoc.x, newLoc.y, newLoc.z);
    }

    public void setPosition(PointD newLoc) {
        this.setPosition(newLoc.x, newLoc.y, newLoc.z);
    }
}

