/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts.trackers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.maths.RotateF;
import net.minecraft.class_630;

public abstract class Tracker {
    protected final class_630 part;
    public class_630 bodyPart = null;
    public RotateF rotationOffset = new RotateF();
    public RotateF rotation = new RotateF();
    public RotateF rotationDiff = new RotateF();
    public RotateF lastRotation = new RotateF();
    public PointD position = new PointD();
    public PointD lastPosition = new PointD();
    public PointD positionDiff = new PointD();
    public RotateF distToLastRotation = new RotateF();
    public PointD offset = new PointD();

    protected Tracker(class_630 part) {
        part.method_2851(0.0f, 0.0f, 0.0f);
        part.field_3654 = 0.0f;
        part.field_3675 = 0.0f;
        part.field_3674 = 0.0f;
        this.part = part;
    }

    public Tracker(class_630 part, float rotateOffsetX, float rotateOffsetY, float rotateOffsetZ) {
        this(part);
        this.rotationOffset = new RotateF(rotateOffsetX, rotateOffsetY, rotateOffsetZ);
    }

    public void render() {
        this.render(1.0f);
    }

    protected void renderPart(float partialTicks) {
        this.renderPart(partialTicks, 0.0625f);
    }

    protected void renderPart(float partialTicks, float scale) {
        GlStateManager.pushMatrix();
        this.smoothLocation(partialTicks);
        this.smoothRotation(partialTicks);
        this.applyOffset();
        this.part.method_2846(scale);
        GlStateManager.popMatrix();
    }

    public void updateLastPos() {
        this.lastRotation.copy(this.rotation);
        this.lastPosition = this.position;
    }

    public void updatePosDifference() {
        this.rotationDiff.copy(this.rotation).sub(this.lastRotation);
        this.positionDiff = this.position.sub(this.lastPosition);
        this.rotationDiff.changeToShortestAngle();
    }

    public abstract void calcPosition();

    protected void smoothLocation(float partialTicks) {
        GlStateManager.translated((double)(this.lastPosition.x + this.positionDiff.x * (double)partialTicks), (double)(this.lastPosition.y + this.positionDiff.y * (double)partialTicks), (double)(this.lastPosition.z + this.positionDiff.z * (double)partialTicks));
    }

    protected void smoothRotation(float partialTicks) {
        this.applyRotation(this.lastRotation.z + this.rotationDiff.z * partialTicks, this.lastRotation.y + this.rotationDiff.y * partialTicks, this.lastRotation.x + this.rotationDiff.x * partialTicks);
    }

    protected void applyOffset() {
        this.applyRotation(this.rotationOffset.x, this.rotationOffset.y, this.rotationOffset.z);
    }

    private void applyRotationDeg(float x, float y, float z) {
        if (z != 0.0f) {
            GlStateManager.rotatef((float)z, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (y != 0.0f) {
            GlStateManager.rotatef((float)y, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (x != 0.0f) {
            GlStateManager.rotatef((float)x, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void applyRotation(float x, float y, float z) {
        this.applyRotationDeg(z * 57.295776f, y * 57.295776f, x * 57.295776f);
    }

    public abstract void render(float var1);
}

