/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.parts.trackers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.sekwah.sekcphysics.maths.PointD;
import com.sekwah.sekcphysics.maths.VectorMaths;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.Tracker;
import net.minecraft.class_630;

public class TrackerTriangle
extends Tracker {
    protected final Triangle triangle;
    protected float lastRotationAxis = 0.0f;
    protected float rotationAxis = 0.0f;
    protected float rotationAxisDiff = 0.0f;

    public TrackerTriangle(class_630 part, Triangle triangle) {
        super(part);
        this.triangle = triangle;
        this.calcPosition();
    }

    public TrackerTriangle(class_630 part, Triangle triangle, float rotateOffsetX, float rotateOffsetY, float rotateOffsetZ) {
        super(part, rotateOffsetX, rotateOffsetY, rotateOffsetZ);
        this.triangle = triangle;
    }

    @Override
    public void render(float partialTicks) {
        this.renderPart(partialTicks);
    }

    @Override
    public void calcPosition() {
        this.updateLastPos();
        PointD triangleDir = this.triangle.getDirection();
        PointD triangleNorm = this.triangle.getNormal();
        this.rotation.y = this.basicRotation(triangleDir.x, triangleDir.z);
        this.rotation.x = 1.5707964f + this.basicRotation(-triangleDir.y, (float)Math.sqrt(triangleDir.x * triangleDir.x + triangleDir.z * triangleDir.z));
        PointD angleDifference = VectorMaths.rotateOriginY(-this.rotation.y, triangleNorm);
        angleDifference = VectorMaths.rotateOriginX(-this.rotation.x, angleDifference);
        this.rotationAxis = this.basicRotation(angleDifference.x, angleDifference.z);
        this.updatePosition();
        this.updatePosDifference();
    }

    @Override
    protected void smoothRotation(float partialTicks) {
        super.smoothRotation(partialTicks);
        GlStateManager.rotatef((float)((float)Math.toDegrees(this.lastRotationAxis + this.rotationAxisDiff * partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    protected void updatePosition() {
        this.position = new PointD(this.triangle.points[0].posX, this.triangle.points[0].posY, this.triangle.points[0].posZ);
    }

    public float basicRotation(double axis1, double axis2) {
        return (float)Math.atan2(axis1, axis2);
    }
}

