/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.sekcphysics.ragdoll.ragdolls;

import com.sekwah.sekcphysics.client.cliententity.RagdollEntity;
import com.sekwah.sekcphysics.ragdoll.parts.Skeleton;
import com.sekwah.sekcphysics.ragdoll.parts.SkeletonPoint;
import com.sekwah.sekcphysics.ragdoll.parts.Triangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.Tracker;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerTriangle;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerTriangleScaled;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerVertex;
import com.sekwah.sekcphysics.ragdoll.parts.trackers.TrackerVertexScaled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_630;

public class BaseRagdoll {
    public final class_3879 baseModel;
    public Map<class_630, Tracker> trackerHashmap = new HashMap<class_630, Tracker>();
    public boolean trackersRegistered = false;
    public Skeleton skeleton;
    public double centerHeightOffset;
    public class_2960 resourceLocation;

    public BaseRagdoll(float centerHeightOffset, class_3879 baseModel) {
        this.baseModel = baseModel;
        this.skeleton = new Skeleton();
        this.centerHeightOffset = centerHeightOffset;
    }

    public void rotateRagdoll(float rotYaw) {
        this.skeleton.rotate(rotYaw);
    }

    public void update(RagdollEntity entity) {
        this.skeleton.update(entity);
    }

    public void shiftPos(double x, double y, double z) {
        this.skeleton.shiftPos(x, y, z);
    }

    public void setStanceToEntity(class_1309 entity) {
        for (SkeletonPoint point : this.skeleton.points) {
            class_243 vec = new class_243(point.posX, point.posY, point.posZ);
            vec.method_1024((float)Math.toRadians(-entity.field_6031));
            point.setPosition(vec.field_1352, vec.field_1351, vec.field_1350);
        }
    }

    public void initTrackers(class_3879 model) {
        this.trackersRegistered = true;
    }

    protected void addVertexTracker(class_630 part, SkeletonPoint anchor, SkeletonPoint pointTo, float scale) {
        if (scale == 1.0f) {
            this.trackerHashmap.put(part, new TrackerVertex(part, anchor, pointTo));
        } else {
            this.trackerHashmap.put(part, new TrackerVertexScaled(part, anchor, pointTo, scale));
        }
    }

    protected void addTriangleTracker(class_630 part, Triangle triangle, float scale) {
        if (scale == 1.0f) {
            this.trackerHashmap.put(part, new TrackerTriangle(part, triangle));
        } else {
            this.trackerHashmap.put(part, new TrackerTriangleScaled(part, triangle, scale));
        }
    }

    protected void addTriangleTracker(class_630 part, Triangle triangle, float rotateOffsetX, float rotateOffsetY, float rotateOffsetZ, float scale) {
        if (scale == 1.0f) {
            this.trackerHashmap.put(part, new TrackerTriangle(part, triangle, rotateOffsetX, rotateOffsetY, rotateOffsetZ));
        } else {
            this.trackerHashmap.put(part, new TrackerTriangleScaled(part, triangle, rotateOffsetX, rotateOffsetY, rotateOffsetZ, scale));
        }
    }

    public boolean isActive() {
        return this.skeleton.isActive();
    }

    public int activeStatus() {
        if (this.isActive()) {
            return 0;
        }
        return this.skeleton.updateCount == 1 ? 2 : 1;
    }
}

