/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.client.ClientProxy;
import com.oitsjustjose.geolosys.client.render.Cutouts;
import com.oitsjustjose.geolosys.common.CommonProxy;
import com.oitsjustjose.geolosys.common.blocks.ModBlocks;
import com.oitsjustjose.geolosys.common.config.ClientConfig;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.config.ModItemsParser;
import com.oitsjustjose.geolosys.common.data.WorldGenDataLoader;
import com.oitsjustjose.geolosys.common.data.modifiers.OsmiumDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.QuartzDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.SulfurDropModifier;
import com.oitsjustjose.geolosys.common.data.modifiers.YelloriumDropModifier;
import com.oitsjustjose.geolosys.common.event.ManualGifting;
import com.oitsjustjose.geolosys.common.items.ModItems;
import com.oitsjustjose.geolosys.common.world.capability.DepositCapProvider;
import com.oitsjustjose.geolosys.common.world.capability.DepositCapStorage;
import com.oitsjustjose.geolosys.common.world.capability.DepositCapability;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="geolosys")
public class Geolosys {
    private static Geolosys instance;
    public static CommonProxy proxy;
    public Logger LOGGER = LogManager.getLogger();

    public Geolosys() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ManualGifting());
        MinecraftForge.EVENT_BUS.register((Object)new ModItemsParser());
        this.configSetup();
    }

    public static Geolosys getInstance() {
        return instance;
    }

    private void configSetup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfig.COMMON_CONFIG);
        CommonConfig.loadConfig(CommonConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("geolosys-common.toml"));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Cutouts.init();
    }

    public void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IDepositCapability.class, (Capability.IStorage)new DepositCapStorage(), DepositCapability::new);
        GeolosysAPI.init();
        proxy.init();
    }

    @SubscribeEvent
    public void onSlashReload(AddReloadListenerEvent evt) {
        evt.addListener((IFutureReloadListener)new WorldGenDataLoader());
    }

    @SubscribeEvent
    public void attachCap(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("geolosys", "pluton"), (ICapabilityProvider)new DepositCapProvider());
        String dimName = ((World)event.getObject()).func_234923_W_().func_240901_a_().toString();
        this.LOGGER.info("Geolosys capability attached for {}", (Object)dimName);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onHover(ItemTooltipEvent event) {
        Collection tags;
        if (!((Boolean)ClientConfig.ENABLE_TAG_DEBUG.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_82882_x && (tags = ItemTags.func_199903_a().func_199913_a((Object)event.getItemStack().func_77973_b())).size() > 0) {
            for (ResourceLocation tag : tags) {
                event.getToolTip().add(new StringTextComponent("\u00a78#" + tag.toString() + "\u00a7r"));
            }
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            ModBlocks.getInstance().register(blockRegistryEvent);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            ModBlocks.getInstance().registerItemBlocks(itemRegistryEvent);
            ModItems.getInstance().register(itemRegistryEvent);
        }

        @SubscribeEvent
        public static void onModifierSerializersRegistry(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
            evt.getRegistry().register((IForgeRegistryEntry)new OsmiumDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "osmium")));
            evt.getRegistry().register((IForgeRegistryEntry)new QuartzDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "quartzes")));
            evt.getRegistry().register((IForgeRegistryEntry)new YelloriumDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "yellorium")));
            evt.getRegistry().register((IForgeRegistryEntry)new SulfurDropModifier.Serializer().setRegistryName(new ResourceLocation("geolosys", "sulfur")));
        }
    }
}

