/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class DepositUtils {
    private static Random random = new Random();
    private static HashSet<BlockState> defaultMatchersCached = null;

    @Nullable
    public static BlockState pick(HashMap<BlockState, Float> map, float totl) {
        if (totl == 1.0f) {
            totl = 0.0f;
            for (Map.Entry<BlockState, Float> e : map.entrySet()) {
                totl += e.getValue().floatValue();
            }
        }
        float rng = random.nextFloat();
        for (Map.Entry<BlockState, Float> e : map.entrySet()) {
            float wt = e.getValue().floatValue();
            if (rng < wt) {
                return e.getKey();
            }
            rng -= wt;
        }
        Geolosys.getInstance().LOGGER.error("Could not reach decision on block to place at Utils#pick");
        return null;
    }

    public static boolean canPlaceInBiome(Biome biome, @Nullable List<Biome> biomes, @Nullable List<BiomeDictionary.Type> biomeTypes, boolean isBiomeFilterBl) {
        boolean matchForBiome = false;
        boolean matchForBiomeType = false;
        if (biomes != null) {
            matchForBiome = biomes.stream().anyMatch(b -> b == biome);
        }
        if (biomeTypes != null) {
            for (BiomeDictionary.Type type : biomeTypes) {
                RegistryKey regKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
                Set dictTypes = BiomeDictionary.getTypes((RegistryKey)regKey);
                matchForBiomeType = dictTypes.stream().anyMatch(dictType -> type.getName().equalsIgnoreCase(dictType.getName()));
                if (!matchForBiomeType) continue;
                break;
            }
        }
        return (matchForBiome || matchForBiomeType) && !isBiomeFilterBl || !matchForBiome && !matchForBiomeType && isBiomeFilterBl;
    }

    public static HashSet<BlockState> getDefaultMatchers() {
        if (defaultMatchersCached == null) {
            defaultMatchersCached = new HashSet();
            ((List)CommonConfig.DEFAULT_REPLACEMENT_MATS.get()).forEach(s -> {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || !DepositUtils.addDefaultMatcher(block)) {
                    Geolosys.getInstance().LOGGER.warn("{} is not a valid block. Please verify.", s);
                }
            });
        }
        return (HashSet)defaultMatchersCached.clone();
    }

    public static boolean addDefaultMatcher(Block block) {
        BlockState defaultState = block.func_176223_P();
        if (!defaultState.func_196958_f()) {
            defaultMatchersCached.add(defaultState);
            return true;
        }
        return false;
    }
}

