/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class DikeDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_dike";
    private HashMap<BlockState, Float> oreToWtMap = new HashMap();
    private HashMap<BlockState, Float> sampleToWtMap = new HashMap();
    private int yMin;
    private int yMax;
    private int baseRadius;
    private int genWt;
    private HashSet<BlockState> blockStateMatchers;
    private String[] dimFilter;
    private boolean isDimFilterBl;
    @Nullable
    private List<BiomeDictionary.Type> biomeTypeFilter;
    @Nullable
    private List<Biome> biomeFilter;
    @Nullable
    private boolean isBiomeFilterBl;
    private float sumWtOres = 0.0f;
    private float sumWtSamples = 0.0f;

    public DikeDeposit(HashMap<BlockState, Float> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int yMin, int yMax, int baseRadius, int genWt, String[] dimFilter, boolean isDimFilterBl, @Nullable List<BiomeDictionary.Type> biomeTypes, @Nullable List<Biome> biomeFilter, @Nullable boolean isBiomeFilterBl, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.baseRadius = baseRadius;
        this.genWt = genWt;
        this.dimFilter = dimFilter;
        this.isDimFilterBl = isDimFilterBl;
        this.biomeTypeFilter = biomeTypes;
        this.isBiomeFilterBl = isBiomeFilterBl;
        this.blockStateMatchers = blockStateMatchers;
        this.biomeFilter = biomeFilter;
        for (Map.Entry<BlockState, Float> e : this.oreToWtMap.entrySet()) {
            this.sumWtOres += e.getValue().floatValue();
        }
        assert (this.sumWtOres == 1.0f) : "Sum of weights for pluton blocks should equal 1.0";
        for (Map.Entry<BlockState, Float> e : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += e.getValue().floatValue();
        }
        assert (this.sumWtSamples == 1.0f) : "Sum of weights for pluton samples should equal 1.0";
    }

    @Nullable
    public BlockState getOre() {
        return DepositUtils.pick(this.oreToWtMap, this.sumWtOres);
    }

    @Nullable
    public BlockState getSample() {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        this.oreToWtMap.keySet().forEach(bs -> {
            if (bs != null) {
                ret.add((BlockState)bs);
            }
        });
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(Biome b) {
        return DepositUtils.canPlaceInBiome(b, this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl);
    }

    @Override
    public boolean hasBiomeRestrictions() {
        return this.biomeFilter != null || this.biomeTypeFilter != null;
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    @Override
    public String[] getDimensionFilter() {
        return this.dimFilter;
    }

    @Override
    public boolean isDimensionFilterBl() {
        return this.isDimFilterBl;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Dike deposit with Blocks=");
        ret.append(Arrays.toString(this.oreToWtMap.keySet().toArray()));
        ret.append(", Samples=");
        ret.append(Arrays.toString(this.sampleToWtMap.keySet().toArray()));
        ret.append(", Y Range=[");
        ret.append(this.yMin);
        ret.append(",");
        ret.append(this.yMax);
        ret.append("], Radius of Base=");
        ret.append(this.baseRadius);
        return ret.toString();
    }

    @Override
    public int generate(ISeedReader reader, BlockPos pos, IDepositCapability cap) {
        if (!DepositUtils.canPlaceInBiome(reader.func_226691_t_(pos), this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl)) {
            return 0;
        }
        ChunkPos thisChunk = new ChunkPos(pos);
        int height = Math.abs(this.yMax - this.yMin);
        int x = thisChunk.func_180334_c() + reader.func_201674_k().nextInt(16);
        int z = thisChunk.func_180333_d() + reader.func_201674_k().nextInt(16);
        int yMin = this.yMin + reader.func_201674_k().nextInt(height / 4);
        int yMax = this.yMax - reader.func_201674_k().nextInt(height / 4);
        int max = Utils.getTopSolidBlock((IWorld)reader, pos).func_177956_o();
        if (yMin > max) {
            yMin = Math.max(yMin, max);
        } else if (yMin == yMax) {
            yMax = this.yMax;
        }
        BlockPos basePos = new BlockPos(x, yMin, z);
        int totlPlaced = 0;
        int htRnd = Math.abs(yMax - yMin);
        int rad = this.baseRadius / 2;
        boolean shouldSub = false;
        for (int dY = yMin; dY <= yMax; ++dY) {
            for (int dX = -rad; dX <= rad; ++dX) {
                for (int dZ = -rad; dZ <= rad; ++dZ) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)rad) continue;
                    BlockPos placePos = new BlockPos(basePos.func_177958_n() + dX, dY, basePos.func_177952_p() + dZ);
                    BlockState tmp = this.getOre();
                    if (tmp == null || !this.getBlockStateMatchers().contains(FeatureUtils.tryGetBlockState(reader, thisChunk, placePos)) || !FeatureUtils.tryPlaceBlock(reader, new ChunkPos(pos), placePos, tmp, cap)) continue;
                    ++totlPlaced;
                }
            }
            if (yMin + htRnd / 2 <= dY) {
                shouldSub = true;
            }
            if (reader.func_201672_e().func_201674_k().nextInt(3) != 0 || (rad += shouldSub ? -1 : 1) > 0) continue;
            return totlPlaced;
        }
        return totlPlaced;
    }

    @Override
    public void afterGen(ISeedReader reader, BlockPos pos, IDepositCapability cap) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.debug("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        ChunkPos thisChunk = new ChunkPos(pos);
        int maxSampleCnt = Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), this.baseRadius / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + this.baseRadius % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get());
        maxSampleCnt = Math.max(maxSampleCnt, 1);
        for (int i = 0; i < maxSampleCnt; ++i) {
            BlockPos samplePos = SampleUtils.getSamplePosition(reader, new ChunkPos(pos));
            BlockState tmp = this.getSample();
            if (tmp == null || samplePos == null || SampleUtils.inNonWaterFluid(reader, samplePos)) continue;
            if (SampleUtils.isInWater(reader, samplePos) && tmp.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                tmp = (BlockState)tmp.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
            }
            FeatureUtils.tryPlaceBlock(reader, thisChunk, samplePos, tmp, cap);
            FeatureUtils.fixSnowyBlock(reader, samplePos);
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static DikeDeposit deserialize(JsonObject json, JsonDeserializationContext ctx) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<BlockState, Float> oreBlocks = SerializerUtils.buildMultiBlockMap(json.get("blocks").getAsJsonArray());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int baseRadius = json.get("baseRadius").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            String[] dimFilter = SerializerUtils.getDimFilter(json);
            boolean isDimFilterBl = SerializerUtils.getIsDimFilterBl(json);
            boolean isBiomeFilterBl = true;
            List<BiomeDictionary.Type> biomeTypeFilter = null;
            List<Biome> biomeFilter = null;
            if (json.has("biomes")) {
                String[] biomeArrRaw = SerializerUtils.getBiomeFilter(json);
                isBiomeFilterBl = SerializerUtils.getIsBiomeFilterBl(json);
                biomeTypeFilter = SerializerUtils.extractBiomeTypes(biomeArrRaw);
                biomeFilter = SerializerUtils.extractBiomes(biomeArrRaw);
            }
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new DikeDeposit(oreBlocks, sampleBlocks, yMin, yMax, baseRadius, genWt, dimFilter, isDimFilterBl, biomeTypeFilter, biomeFilter, isBiomeFilterBl, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse JSON file: {}", (Object)json.toString());
            return null;
        }
    }

    public JsonElement serialize(DikeDeposit dep, JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        JsonParser parser = new JsonParser();
        JsonObject biomes = new JsonObject();
        biomes.addProperty("isBlacklist", Boolean.valueOf(this.isBiomeFilterBl));
        biomes.add("filter", (JsonElement)SerializerUtils.deconstructBiomes(this.biomeFilter, this.biomeTypeFilter));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("isBlacklist", Boolean.valueOf(this.isDimFilterBl));
        dimensions.add("filter", parser.parse(Arrays.toString(this.dimFilter)));
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.oreToWtMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("baseRadius", (Number)this.baseRadius);
        config.addProperty("generationWeight", (Number)this.genWt);
        config.add("dimensions", (JsonElement)dimensions);
        config.add("biomes", (JsonElement)biomes);
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

