/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class SparseDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_sparse";
    private HashMap<BlockState, Float> oreToWtMap = new HashMap();
    private HashMap<BlockState, Float> sampleToWtMap = new HashMap();
    private int yMin;
    private int yMax;
    private int size;
    private int spread;
    private int genWt;
    private HashSet<BlockState> blockStateMatchers;
    private String[] dimFilter;
    private boolean isDimFilterBl;
    @Nullable
    private List<BiomeDictionary.Type> biomeTypeFilter;
    @Nullable
    private List<Biome> biomeFilter;
    @Nullable
    private boolean isBiomeFilterBl;
    private float sumWtOres = 0.0f;
    private float sumWtSamples = 0.0f;

    public SparseDeposit(HashMap<BlockState, Float> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int yMin, int yMax, int size, int spread, int genWt, String[] dimFilter, boolean isDimFilterBl, @Nullable List<BiomeDictionary.Type> biomeTypes, @Nullable List<Biome> biomeFilter, @Nullable boolean isBiomeFilterBl, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.yMin = yMin;
        this.yMax = yMax;
        this.size = size;
        this.spread = spread;
        this.genWt = genWt;
        this.dimFilter = dimFilter;
        this.isDimFilterBl = isDimFilterBl;
        this.biomeTypeFilter = biomeTypes;
        this.isBiomeFilterBl = isBiomeFilterBl;
        this.blockStateMatchers = blockStateMatchers;
        this.biomeFilter = biomeFilter;
        for (Map.Entry<BlockState, Float> e : this.oreToWtMap.entrySet()) {
            this.sumWtOres += e.getValue().floatValue();
        }
        assert (this.sumWtOres == 1.0f) : "Sum of weights for pluton blocks should equal 1.0";
        for (Map.Entry<BlockState, Float> e : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += e.getValue().floatValue();
        }
        assert (this.sumWtSamples == 1.0f) : "Sum of weights for pluton samples should equal 1.0";
    }

    @Nullable
    public BlockState getOre() {
        return DepositUtils.pick(this.oreToWtMap, this.sumWtOres);
    }

    @Nullable
    public BlockState getSample() {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        this.oreToWtMap.keySet().forEach(bs -> {
            if (bs != null) {
                ret.add((BlockState)bs);
            }
        });
        return ret.isEmpty() ? null : ret;
    }

    @Override
    public boolean canPlaceInBiome(Biome b) {
        return DepositUtils.canPlaceInBiome(b, this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl);
    }

    @Override
    public boolean hasBiomeRestrictions() {
        return this.biomeFilter != null || this.biomeTypeFilter != null;
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    @Override
    public String[] getDimensionFilter() {
        return this.dimFilter;
    }

    @Override
    public boolean isDimensionFilterBl() {
        return this.isDimFilterBl;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Sparse deposit with Blocks=");
        ret.append(Arrays.toString(this.oreToWtMap.keySet().toArray()));
        ret.append(", Samples=");
        ret.append(Arrays.toString(this.sampleToWtMap.keySet().toArray()));
        ret.append(", Y Range=[");
        ret.append(this.yMin);
        ret.append(",");
        ret.append(this.yMax);
        ret.append("], Size of deposit =");
        ret.append(this.size);
        ret.append(", Spread=");
        ret.append(this.spread);
        return ret.toString();
    }

    @Override
    public int generate(ISeedReader reader, BlockPos pos, IDepositCapability cap) {
        int max;
        if (!DepositUtils.canPlaceInBiome(reader.func_226691_t_(pos), this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl)) {
            return 0;
        }
        int totlPlaced = 0;
        int totlPnding = 0;
        ChunkPos thisChunk = new ChunkPos(pos);
        int randY = this.yMin + reader.func_201674_k().nextInt(this.yMax - this.yMin);
        if (randY > (max = Utils.getTopSolidBlock((IWorld)reader, pos).func_177956_o())) {
            randY = Math.max(this.yMin, max);
        }
        float ranFlt = reader.func_201674_k().nextFloat() * (float)Math.PI;
        double x1 = (float)(pos.func_177958_n() + 8) + MathHelper.func_76126_a((float)ranFlt) * (float)this.size / 8.0f;
        double x2 = (float)(pos.func_177958_n() + 8) - MathHelper.func_76126_a((float)ranFlt) * (float)this.size / 8.0f;
        double z1 = (float)(pos.func_177952_p() + 8) + MathHelper.func_76134_b((float)ranFlt) * (float)this.size / 8.0f;
        double z2 = (float)(pos.func_177952_p() + 8) - MathHelper.func_76134_b((float)ranFlt) * (float)this.size / 8.0f;
        double y1 = randY + reader.func_201674_k().nextInt(3) - 2;
        double y2 = randY + reader.func_201674_k().nextInt(3) - 2;
        for (int i = 0; i < this.size; ++i) {
            float radScl = (float)i / (float)this.size;
            double xn = x1 + (x2 - x1) * (double)radScl;
            double yn = y1 + (y2 - y1) * (double)radScl;
            double zn = z1 + (z2 - z1) * (double)radScl;
            double noise = reader.func_201674_k().nextDouble() * (double)this.size / 16.0;
            double radius = (double)(MathHelper.func_76126_a((float)((float)Math.PI * radScl)) + 1.0f) * noise + 1.0;
            int xmin = MathHelper.func_76128_c((double)(xn - radius / 2.0));
            int ymin = MathHelper.func_76128_c((double)(yn - radius / 2.0));
            int zmin = MathHelper.func_76128_c((double)(zn - radius / 2.0));
            int xmax = MathHelper.func_76128_c((double)(xn + radius / 2.0));
            int ymax = MathHelper.func_76128_c((double)(yn + radius / 2.0));
            int zmax = MathHelper.func_76128_c((double)(zn + radius / 2.0));
            for (int x = xmin; x <= xmax; ++x) {
                double layerRadX = ((double)x + 0.5 - xn) / (radius / 2.0);
                if (!(layerRadX * layerRadX < 1.0)) continue;
                for (int y = ymin; y <= ymax; ++y) {
                    double layerRadY = ((double)y + 0.5 - yn) / (radius / 2.0);
                    if (!(layerRadX * layerRadX + layerRadY * layerRadY < 1.0)) continue;
                    for (int z = zmin; z <= zmax; ++z) {
                        double layerRadZ = ((double)z + 0.5 - zn) / (radius / 2.0);
                        if (!(layerRadX * layerRadX + layerRadY * layerRadY + layerRadZ * layerRadZ < 1.0)) continue;
                        int xSpread = reader.func_201674_k().nextInt(this.spread) * (reader.func_201674_k().nextBoolean() ? 1 : -1);
                        int zSpread = reader.func_201674_k().nextInt(this.spread) * (reader.func_201674_k().nextBoolean() ? 1 : -1);
                        BlockPos placePos = new BlockPos(x + xSpread, y, z + zSpread);
                        BlockState tmp = this.getOre();
                        if (tmp == null || !this.getBlockStateMatchers().contains(FeatureUtils.tryGetBlockState(reader, thisChunk, placePos))) continue;
                        if (FeatureUtils.tryPlaceBlock(reader, thisChunk, placePos, tmp, cap)) {
                            ++totlPlaced;
                            continue;
                        }
                        ++totlPnding;
                    }
                }
            }
        }
        return totlPlaced + totlPnding;
    }

    @Override
    public void afterGen(ISeedReader reader, BlockPos pos, IDepositCapability cap) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.debug("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
        ChunkPos thisChunk = new ChunkPos(pos);
        int maxSampleCnt = Math.min((Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get(), this.size / (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get() + this.size % (Integer)CommonConfig.MAX_SAMPLES_PER_CHUNK.get()) * (this.spread / 16);
        for (int i = 0; i < maxSampleCnt; ++i) {
            BlockPos samplePos = SampleUtils.getSamplePosition(reader, new ChunkPos(pos), this.spread);
            BlockState tmp = this.getSample();
            if (tmp == null || samplePos == null || SampleUtils.inNonWaterFluid(reader, samplePos)) continue;
            if (SampleUtils.isInWater(reader, samplePos) && tmp.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                tmp = (BlockState)tmp.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
            }
            FeatureUtils.tryPlaceBlock(reader, thisChunk, samplePos, tmp, cap);
            FeatureUtils.fixSnowyBlock(reader, samplePos);
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static SparseDeposit deserialize(JsonObject json, JsonDeserializationContext ctx) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<BlockState, Float> oreBlocks = SerializerUtils.buildMultiBlockMap(json.get("blocks").getAsJsonArray());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int yMin = json.get("yMin").getAsInt();
            int yMax = json.get("yMax").getAsInt();
            int spread = json.get("spread").getAsInt();
            int size = json.get("size").getAsInt();
            int genWt = json.get("generationWeight").getAsInt();
            String[] dimFilter = SerializerUtils.getDimFilter(json);
            boolean isDimFilterBl = SerializerUtils.getIsDimFilterBl(json);
            boolean isBiomeFilterBl = true;
            List<BiomeDictionary.Type> biomeTypeFilter = null;
            List<Biome> biomeFilter = null;
            if (json.has("biomes")) {
                String[] biomeArrRaw = SerializerUtils.getBiomeFilter(json);
                isBiomeFilterBl = SerializerUtils.getIsBiomeFilterBl(json);
                biomeTypeFilter = SerializerUtils.extractBiomeTypes(biomeArrRaw);
                biomeFilter = SerializerUtils.extractBiomes(biomeArrRaw);
            }
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new SparseDeposit(oreBlocks, sampleBlocks, yMin, yMax, size, spread, genWt, dimFilter, isDimFilterBl, biomeTypeFilter, biomeFilter, isBiomeFilterBl, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse JSON file: {}", (Object)json.toString());
            return null;
        }
    }

    public JsonElement serialize(SparseDeposit dep, JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        JsonParser parser = new JsonParser();
        JsonObject biomes = new JsonObject();
        biomes.addProperty("isBlacklist", Boolean.valueOf(this.isBiomeFilterBl));
        biomes.add("filter", (JsonElement)SerializerUtils.deconstructBiomes(this.biomeFilter, this.biomeTypeFilter));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("isBlacklist", Boolean.valueOf(this.isDimFilterBl));
        dimensions.add("filter", parser.parse(Arrays.toString(this.dimFilter)));
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.oreToWtMap));
        config.addProperty("yMin", (Number)this.yMin);
        config.addProperty("yMax", (Number)this.yMax);
        config.addProperty("size", (Number)this.size);
        config.addProperty("spread", (Number)this.spread);
        config.addProperty("generationWeight", (Number)this.genWt);
        config.add("dimensions", (JsonElement)dimensions);
        config.add("biomes", (JsonElement)biomes);
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

