/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.api.world.deposit;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.DepositUtils;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.data.serializer.SerializerUtils;
import com.oitsjustjose.geolosys.common.utils.Utils;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TopLayerDeposit
implements IDeposit {
    public static final String JSON_TYPE = "geolosys:deposit_top_layer";
    private HashMap<BlockState, Float> oreToWtMap = new HashMap();
    private HashMap<BlockState, Float> sampleToWtMap = new HashMap();
    private int radius;
    private int depth;
    private float sampleChance;
    private int genWt;
    private HashSet<BlockState> blockStateMatchers;
    private String[] dimFilter;
    private boolean isDimFilterBl;
    @Nullable
    private List<BiomeDictionary.Type> biomeTypeFilter;
    @Nullable
    private List<Biome> biomeFilter;
    @Nullable
    private boolean isBiomeFilterBl;
    private float sumWtOres = 0.0f;
    private float sumWtSamples = 0.0f;

    public TopLayerDeposit(HashMap<BlockState, Float> oreBlocks, HashMap<BlockState, Float> sampleBlocks, int radius, int depth, float sampleChance, int genWt, String[] dimFilter, boolean isDimFilterBl, @Nullable List<BiomeDictionary.Type> biomeTypes, @Nullable List<Biome> biomeFilter, @Nullable boolean isBiomeFilterBl, HashSet<BlockState> blockStateMatchers) {
        this.oreToWtMap = oreBlocks;
        this.sampleToWtMap = sampleBlocks;
        this.radius = radius;
        this.depth = depth;
        this.sampleChance = sampleChance;
        this.genWt = genWt;
        this.dimFilter = dimFilter;
        this.isDimFilterBl = isDimFilterBl;
        this.biomeTypeFilter = biomeTypes;
        this.isBiomeFilterBl = isBiomeFilterBl;
        this.blockStateMatchers = blockStateMatchers;
        this.biomeFilter = biomeFilter;
        for (Map.Entry<BlockState, Float> e : this.oreToWtMap.entrySet()) {
            this.sumWtOres += e.getValue().floatValue();
        }
        assert (this.sumWtOres == 1.0f) : "Sum of weights for pluton blocks should equal 1.0";
        for (Map.Entry<BlockState, Float> e : this.sampleToWtMap.entrySet()) {
            this.sumWtSamples += e.getValue().floatValue();
        }
        assert (this.sumWtSamples == 1.0f) : "Sum of weights for pluton samples should equal 1.0";
    }

    @Nullable
    public BlockState getOre() {
        return DepositUtils.pick(this.oreToWtMap, this.sumWtOres);
    }

    @Nullable
    public BlockState getSample() {
        return DepositUtils.pick(this.sampleToWtMap, this.sumWtSamples);
    }

    @Override
    @Nullable
    public HashSet<BlockState> getAllOres() {
        return null;
    }

    @Override
    public boolean canPlaceInBiome(Biome b) {
        return DepositUtils.canPlaceInBiome(b, this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl);
    }

    @Override
    public boolean hasBiomeRestrictions() {
        return this.biomeFilter != null || this.biomeTypeFilter != null;
    }

    @Override
    public int getGenWt() {
        return this.genWt;
    }

    @Override
    public String[] getDimensionFilter() {
        return this.dimFilter;
    }

    @Override
    public boolean isDimensionFilterBl() {
        return this.isDimFilterBl;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Top Layer deposit with Blocks=");
        ret.append(Arrays.toString(this.oreToWtMap.keySet().toArray()));
        ret.append(", Samples=");
        ret.append(Arrays.toString(this.sampleToWtMap.keySet().toArray()));
        ret.append(", Radius=");
        ret.append(this.radius);
        ret.append(", Depth=");
        ret.append(this.depth);
        return ret.toString();
    }

    @Override
    public int generate(ISeedReader reader, BlockPos pos, IDepositCapability cap) {
        if (!DepositUtils.canPlaceInBiome(reader.func_226691_t_(pos), this.biomeFilter, this.biomeTypeFilter, this.isBiomeFilterBl)) {
            return 0;
        }
        int totlPlaced = 0;
        ChunkPos thisChunk = new ChunkPos(pos);
        int x = (thisChunk.func_180334_c() + thisChunk.func_180332_e()) / 2 - reader.func_201674_k().nextInt(8) + reader.func_201674_k().nextInt(16);
        int z = (thisChunk.func_180333_d() + thisChunk.func_180330_f()) / 2 - reader.func_201674_k().nextInt(8) + reader.func_201674_k().nextInt(16);
        int radX = this.radius / 2 + reader.func_201674_k().nextInt(this.radius / 2);
        int radZ = this.radius / 2 + reader.func_201674_k().nextInt(this.radius / 2);
        BlockPos basePos = new BlockPos(x, 0, z);
        for (int dX = -radX; dX <= radX; ++dX) {
            for (int dZ = -radZ; dZ <= radZ; ++dZ) {
                if (dX * dX + dZ * dZ > this.radius + reader.func_201674_k().nextInt(Math.max(1, this.radius / 2))) continue;
                BlockPos baseForXZ = Utils.getTopSolidBlock((IWorld)reader, basePos.func_177982_a(dX, 0, dZ));
                for (int i = 0; i < this.depth; ++i) {
                    BlockState smpl;
                    boolean isTop;
                    BlockPos placePos = baseForXZ.func_177979_c(i);
                    BlockState tmp = this.getOre();
                    boolean bl = isTop = i == 0;
                    if (tmp == null) continue;
                    if (tmp.func_235901_b_((Property)BlockStateProperties.field_222513_b)) {
                        tmp = (BlockState)tmp.func_206870_a((Property)BlockStateProperties.field_222513_b, (Comparable)Boolean.valueOf(!isTop));
                    }
                    if (!this.getBlockStateMatchers().contains(FeatureUtils.tryGetBlockState(reader, thisChunk, placePos)) || !FeatureUtils.tryPlaceBlock(reader, thisChunk, placePos, tmp, cap)) continue;
                    ++totlPlaced;
                    if (!isTop || !(reader.func_201674_k().nextFloat() <= this.sampleChance) || (smpl = this.getSample()) == null) continue;
                    FeatureUtils.tryPlaceBlock(reader, thisChunk, placePos.func_177984_a(), smpl, cap);
                    FeatureUtils.fixSnowyBlock(reader, placePos);
                }
            }
        }
        return totlPlaced;
    }

    @Override
    public void afterGen(ISeedReader reader, BlockPos pos, IDepositCapability cap) {
        if (((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) {
            Geolosys.getInstance().LOGGER.debug("Generated {} in Chunk {} (Pos [{} {} {}])", (Object)this.toString(), (Object)new ChunkPos(pos), (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
        }
    }

    @Override
    public HashSet<BlockState> getBlockStateMatchers() {
        return this.blockStateMatchers == null ? DepositUtils.getDefaultMatchers() : this.blockStateMatchers;
    }

    public static TopLayerDeposit deserialize(JsonObject json, JsonDeserializationContext ctx) {
        if (json == null) {
            return null;
        }
        try {
            HashMap<BlockState, Float> oreBlocks = SerializerUtils.buildMultiBlockMap(json.get("blocks").getAsJsonArray());
            HashMap<BlockState, Float> sampleBlocks = SerializerUtils.buildMultiBlockMap(json.get("samples").getAsJsonArray());
            int radius = json.get("radius").getAsInt();
            int depth = json.get("depth").getAsInt();
            float sampleChance = json.get("chanceForSample").getAsFloat();
            int genWt = json.get("generationWeight").getAsInt();
            String[] dimFilter = SerializerUtils.getDimFilter(json);
            boolean isDimFilterBl = SerializerUtils.getIsDimFilterBl(json);
            boolean isBiomeFilterBl = true;
            List<BiomeDictionary.Type> biomeTypeFilter = null;
            List<Biome> biomeFilter = null;
            if (json.has("biomes")) {
                String[] biomeArrRaw = SerializerUtils.getBiomeFilter(json);
                isBiomeFilterBl = SerializerUtils.getIsBiomeFilterBl(json);
                biomeTypeFilter = SerializerUtils.extractBiomeTypes(biomeArrRaw);
                biomeFilter = SerializerUtils.extractBiomes(biomeArrRaw);
            }
            HashSet<BlockState> blockStateMatchers = DepositUtils.getDefaultMatchers();
            if (json.has("blockStateMatchers")) {
                blockStateMatchers = SerializerUtils.toBlockStateList(json.get("blockStateMatchers").getAsJsonArray());
            }
            return new TopLayerDeposit(oreBlocks, sampleBlocks, radius, depth, sampleChance, genWt, dimFilter, isDimFilterBl, biomeTypeFilter, biomeFilter, isBiomeFilterBl, blockStateMatchers);
        }
        catch (Exception e) {
            Geolosys.getInstance().LOGGER.error("Failed to parse JSON file: {}", (Object)json.toString());
            return null;
        }
    }

    public JsonElement serialize(TopLayerDeposit dep, JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        JsonObject config = new JsonObject();
        JsonParser parser = new JsonParser();
        JsonObject biomes = new JsonObject();
        biomes.addProperty("isBlacklist", Boolean.valueOf(this.isBiomeFilterBl));
        biomes.add("filter", (JsonElement)SerializerUtils.deconstructBiomes(this.biomeFilter, this.biomeTypeFilter));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("isBlacklist", Boolean.valueOf(this.isDimFilterBl));
        dimensions.add("filter", parser.parse(Arrays.toString(this.dimFilter)));
        config.add("blocks", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.oreToWtMap));
        config.add("samples", (JsonElement)SerializerUtils.deconstructMultiBlockMap(this.oreToWtMap));
        config.addProperty("radius", (Number)this.radius);
        config.addProperty("depth", (Number)this.depth);
        config.addProperty("chanceForSample", (Number)Float.valueOf(this.sampleChance));
        config.addProperty("generationWeight", (Number)this.genWt);
        config.add("dimensions", (JsonElement)dimensions);
        config.add("biomes", (JsonElement)biomes);
        json.addProperty("type", JSON_TYPE);
        json.add("config", (JsonElement)config);
        return json;
    }
}

