/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.oitsjustjose.geolosys.common.blocks.OreBlock;
import com.oitsjustjose.geolosys.common.blocks.PeatBlock;
import com.oitsjustjose.geolosys.common.blocks.PlantBlock;
import com.oitsjustjose.geolosys.common.blocks.SampleBlock;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    private static ModBlocks instance;
    private ArrayList<Block> extras = new ArrayList();
    public Block peat = (Block)new PeatBlock().setRegistryName("geolosys", "peat");
    public Block rhododendron = (Block)new PlantBlock(false, this.peat).setRegistryName("geolosys", "rhododendron");

    private ModBlocks() {
        for (Types.Ores oreType : Types.Ores.values()) {
            String SAMPLE_REGISTRY_NAME = oreType.getName().toLowerCase() + "_ore_sample";
            String ORE_REGISTRY_NAME = oreType.getName().toLowerCase() + "_ore";
            AbstractBlock.Properties blockProp = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(7.5f, 10.0f).func_200947_a(SoundType.field_185851_d).harvestLevel(oreType.getToolLevel()).harvestTool(ToolType.PICKAXE).func_235861_h_();
            Block block = (Block)new OreBlock(blockProp, oreType.getXp()).setRegistryName("geolosys", ORE_REGISTRY_NAME);
            Block sample = (Block)new SampleBlock().setRegistryName("geolosys", SAMPLE_REGISTRY_NAME);
            oreType.setSample(sample);
            oreType.setBlock(block);
        }
        this.extras.add(this.peat);
        this.extras.add(this.rhododendron);
    }

    public static ModBlocks getInstance() {
        if (instance == null) {
            instance = new ModBlocks();
        }
        return instance;
    }

    public void register(RegistryEvent.Register<Block> blockRegistryEvent) {
        for (Types.Ores oreType : Types.Ores.values()) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)oreType.getBlock());
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)oreType.getSample());
        }
        for (Block extra : this.extras) {
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)extra);
        }
    }

    public void registerItemBlocks(RegistryEvent.Register<Item> itemRegistryEvent) {
        Item iBlock;
        for (Types.Ores oreType : Types.Ores.values()) {
            iBlock = (Item)new BlockItem(oreType.getBlock(), new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance())).setRegistryName(oreType.getBlock().getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
        for (Types.Ores oreType : Types.Ores.values()) {
            iBlock = (Item)new BlockItem(oreType.getSample(), new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance())).setRegistryName(oreType.getSample().getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock);
        }
        for (Block extra : this.extras) {
            Item iBlock2 = (Item)new BlockItem(extra, new Item.Properties().func_200916_a((ItemGroup)GeolosysGroup.getInstance())).setRegistryName(extra.getRegistryName());
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)iBlock2);
        }
    }
}

