/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.config;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.SampleUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ModItemsParser {
    private void load() {
        this.loadSamplePlacementBlacklist();
    }

    private void loadSamplePlacementBlacklist() {
        ((List)CommonConfig.SAMPLE_PLACEMENT_BLACKLIST.get()).forEach(s -> {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (block != null) {
                SampleUtils.addSamplePlacementBlacklist(block);
                Geolosys.getInstance().LOGGER.info("Successfully added block {} to samplePlacementBlacklist", (Object)block.getRegistryName());
            } else {
                Geolosys.getInstance().LOGGER.warn("The item {} in the samplePlacementBlacklist config option was not valid", s);
            }
        });
    }

    @SubscribeEvent
    public void onServerStart(FMLServerAboutToStartEvent evt) {
        this.load();
    }

    @SubscribeEvent
    public void registerSlashReloadLogic(AddReloadListenerEvent evt) {
        evt.addListener((IFutureReloadListener)new ReloadListener<Void>(){

            protected void apply(@Nonnull Void objectIn, @Nonnull IResourceManager resourceMgr, @Nonnull IProfiler profilerIn) {
                ModItemsParser.this.load();
            }

            @Nonnull
            protected Void prepare(@Nonnull IResourceManager resourceMgr, @Nonnull IProfiler profilerIn) {
                return null;
            }
        });
    }
}

