/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.modifiers;

import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.common.config.CompatConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class OsmiumDropModifier
extends LootModifier {
    private Random rand = new Random();
    private float chance;
    private Item item;
    private int qty;

    public OsmiumDropModifier(ILootCondition[] conditions, Item item, float chance, int qty) {
        super(conditions);
        this.chance = chance;
        this.item = item;
        this.qty = qty;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> gennedLoot, LootContext ctx) {
        ItemStack ctxTool = (ItemStack)ctx.func_216031_c(LootParameters.field_216289_i);
        if (((Boolean)CompatConfig.ENABLE_OSMIUM.get()).booleanValue() && (((Boolean)CompatConfig.ENABLE_OSMIUM_EXCLUSIVELY.get()).booleanValue() || this.rand.nextFloat() < this.chance) && ctxTool != null && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)ctxTool) == 0) {
            gennedLoot.clear();
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ctxTool);
            gennedLoot.add(new ItemStack((IItemProvider)this.item, this.qty * ctx.func_216032_b().nextInt(fortune + 1)));
        }
        return gennedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<OsmiumDropModifier> {
        public OsmiumDropModifier read(ResourceLocation name, JsonObject obj, ILootCondition[] cond) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"item")));
            float chance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
            int qty = JSONUtils.func_151203_m((JsonObject)obj, (String)"qty");
            return new OsmiumDropModifier(cond, i, chance, qty);
        }

        public JsonObject write(OsmiumDropModifier instance) {
            return null;
        }
    }
}

