/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.modifiers;

import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.common.config.CompatConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class SulfurDropModifier
extends LootModifier {
    private Random rand = new Random();
    private float chance;
    private Item item;
    private int qty;

    public SulfurDropModifier(ILootCondition[] conditions, Item item, float chance, int qty) {
        super(conditions);
        this.chance = chance;
        this.item = item;
        this.qty = qty;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> gennedLoot, LootContext ctx) {
        if (this.item == null) {
            return gennedLoot;
        }
        if (((Boolean)CompatConfig.ENABLE_SULFUR.get()).booleanValue() && this.rand.nextFloat() < this.chance) {
            gennedLoot.add(new ItemStack((IItemProvider)this.item, this.qty));
        }
        return gennedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SulfurDropModifier> {
        public SulfurDropModifier read(ResourceLocation name, JsonObject obj, ILootCondition[] cond) {
            Item i = null;
            float chance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
            int qty = JSONUtils.func_151203_m((JsonObject)obj, (String)"qty");
            ResourceLocation tagRes = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"tag"));
            ITag tag = ItemTags.func_199903_a().func_199910_a(tagRes);
            if (tag != null && tag.func_230236_b_().size() > 0) {
                i = (Item)tag.func_230236_b_().get(0);
            }
            return new SulfurDropModifier(cond, i, chance, qty);
        }

        public JsonObject write(SulfurDropModifier instance) {
            return null;
        }
    }
}

