/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.modifiers;

import com.google.gson.JsonObject;
import com.oitsjustjose.geolosys.common.config.CompatConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class YelloriumDropModifier
extends LootModifier {
    private Random rand = new Random();
    private float chance;
    private Item item;
    private int qty;

    public YelloriumDropModifier(ILootCondition[] conditions, Item item, float chance, int qty) {
        super(conditions);
        this.chance = chance;
        this.item = item;
        this.qty = qty;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> gennedLoot, LootContext ctx) {
        if (((Boolean)CompatConfig.ENABLE_YELLORIUM.get()).booleanValue() && this.rand.nextFloat() < this.chance) {
            gennedLoot.clear();
            gennedLoot.add(new ItemStack((IItemProvider)this.item, this.qty));
        }
        return gennedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<YelloriumDropModifier> {
        public YelloriumDropModifier read(ResourceLocation name, JsonObject obj, ILootCondition[] cond) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)obj, (String)"item")));
            float chance = JSONUtils.func_151217_k((JsonObject)obj, (String)"chance");
            int qty = JSONUtils.func_151203_m((JsonObject)obj, (String)"qty");
            return new YelloriumDropModifier(cond, i, chance, qty);
        }

        public JsonObject write(YelloriumDropModifier instance) {
            return null;
        }
    }
}

