/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.data.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;

public class SerializerUtils {
    public static String[] getDimFilter(JsonObject obj) {
        if (obj.has("dimensions") && obj.get("dimensions").isJsonObject()) {
            return SerializerUtils.toStringArray(obj.get("dimensions").getAsJsonObject().get("filter").getAsJsonArray());
        }
        return SerializerUtils.toStringArray(obj.get("dimBlacklist").getAsJsonArray());
    }

    public static boolean getIsDimFilterBl(JsonObject obj) {
        if (obj.has("dimensions") && obj.get("dimensions").isJsonObject()) {
            return obj.get("dimensions").getAsJsonObject().get("isBlacklist").getAsBoolean();
        }
        return true;
    }

    @Nullable
    public static String[] getBiomeFilter(JsonObject obj) {
        if (obj.has("biomes") && obj.get("biomes").isJsonObject()) {
            return SerializerUtils.toStringArray(obj.get("biomes").getAsJsonObject().get("filter").getAsJsonArray());
        }
        return null;
    }

    public static boolean getIsBiomeFilterBl(JsonObject obj) {
        if (obj.has("biomes") && obj.get("biomes").isJsonObject()) {
            return obj.get("biomes").getAsJsonObject().get("isBlacklist").getAsBoolean();
        }
        return true;
    }

    public static JsonArray deconstructBiomes(List<Biome> biomes, List<BiomeDictionary.Type> types) {
        JsonArray ret = new JsonArray();
        for (Biome b : biomes) {
            ret.add(b.getRegistryName().toString());
        }
        for (BiomeDictionary.Type t : types) {
            ret.add(t.getName());
        }
        return ret;
    }

    @Nullable
    public static BlockState fromString(@Nullable String string) {
        ResourceLocation r = new ResourceLocation(string);
        return ((Block)ForgeRegistries.BLOCKS.getValue(r)).func_176223_P();
    }

    public static String[] toStringArray(JsonArray arr) {
        String[] ret = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            ret[i] = arr.get(i).getAsString();
        }
        return ret;
    }

    public static HashSet<BlockState> toBlockStateList(JsonArray arr) {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        for (String s : SerializerUtils.toStringArray(arr)) {
            ret.add(SerializerUtils.fromString(s));
        }
        return ret;
    }

    public static HashMap<BlockState, Float> buildMultiBlockMap(JsonArray arr) {
        HashMap<BlockState, Float> ret = new HashMap<BlockState, Float>();
        for (JsonElement j : arr) {
            JsonObject pair = j.getAsJsonObject();
            if (pair.get("block").isJsonNull()) {
                ret.put(null, Float.valueOf(pair.get("chance").getAsFloat()));
                continue;
            }
            ret.put(SerializerUtils.fromString(pair.get("block").getAsString()), Float.valueOf(pair.get("chance").getAsFloat()));
        }
        return ret;
    }

    public static JsonArray deconstructMultiBlockMap(HashMap<BlockState, Float> in) {
        JsonArray ret = new JsonArray();
        for (Map.Entry<BlockState, Float> e : in.entrySet()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("block", e.getKey().func_177230_c().getRegistryName().toString());
            obj.addProperty("chance", (Number)e.getValue());
            ret.add((JsonElement)obj);
        }
        return ret;
    }

    public static List<BiomeDictionary.Type> extractBiomeTypes(String[] arr) {
        ArrayList<BiomeDictionary.Type> ret = new ArrayList<BiomeDictionary.Type>();
        block0: for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
            for (String type : arr) {
                if (!biomeType.getName().equalsIgnoreCase(type)) continue;
                if (ret.contains(biomeType)) continue block0;
                ret.add(biomeType);
                continue block0;
            }
        }
        return ret;
    }

    public static List<Biome> extractBiomes(String[] arr) {
        ArrayList<Biome> ret = new ArrayList<Biome>();
        for (String s : arr) {
            ResourceLocation r = new ResourceLocation(s.toLowerCase());
            if (!ForgeRegistries.BIOMES.containsKey(r)) continue;
            ret.add((Biome)ForgeRegistries.BIOMES.getValue(r));
        }
        return ret;
    }
}

