/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.items;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.ClientConfig;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.utils.GeolosysGroup;
import com.oitsjustjose.geolosys.common.utils.Prospecting;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ProPickItem
extends Item {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("geolosys", "prospectors_pick");

    public ProPickItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)GeolosysGroup.getInstance()));
        this.setRegistryName(REGISTRY_NAME);
        Geolosys.proxy.registerClientSubscribeEvent((Object)this);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (((Boolean)CommonConfig.ENABLE_PRO_PICK_DMG.get()).booleanValue()) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new CompoundNBT());
                stack.func_77978_p().func_74768_a("damage", ((Integer)CommonConfig.PRO_PICK_DURABILITY.get()).intValue());
            }
            return 1.0 - (double)stack.func_77978_p().func_74762_e("damage") / (double)((Integer)CommonConfig.PRO_PICK_DURABILITY.get()).intValue();
        }
        return 1.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (((Boolean)CommonConfig.ENABLE_PRO_PICK_DMG.get()).booleanValue() && Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("damage")) {
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + CommonConfig.PRO_PICK_DURABILITY.get()));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent("Durability: " + stack.func_77978_p().func_74762_e("damage") + "/" + CommonConfig.PRO_PICK_DURABILITY.get()));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return (Boolean)CommonConfig.ENABLE_PRO_PICK_DMG.get() != false && stack.func_77942_o();
    }

    public void attemptDamageItem(PlayerEntity player, BlockPos pos, Hand hand, World worldIn) {
        if (((Boolean)CommonConfig.ENABLE_PRO_PICK_DMG.get()).booleanValue() && !player.func_184812_l_() && player.func_184586_b(hand).func_77973_b() instanceof ProPickItem) {
            if (player.func_184586_b(hand).func_77978_p() == null) {
                player.func_184586_b(hand).func_77982_d(new CompoundNBT());
                player.func_184586_b(hand).func_77978_p().func_74768_a("damage", ((Integer)CommonConfig.PRO_PICK_DURABILITY.get()).intValue());
            }
            int prevDmg = player.func_184586_b(hand).func_77978_p().func_74762_e("damage");
            player.func_184586_b(hand).func_77978_p().func_74768_a("damage", prevDmg - 1);
            if (player.func_184586_b(hand).func_77978_p().func_74762_e("damage") <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                worldIn.func_184133_a(player, pos, new SoundEvent(new ResourceLocation("entity.item.break")), SoundCategory.PLAYERS, 1.0f, 0.85f);
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        if (player.func_213453_ef()) {
            this.func_77659_a(worldIn, player, hand);
        } else {
            if (!player.func_184812_l_()) {
                this.attemptDamageItem(player, pos, hand, worldIn);
            }
            if (worldIn.field_72995_K) {
                player.func_184609_a(hand);
                return ActionResultType.PASS;
            }
            ItemStack stack = player.func_184586_b(hand);
            int confAmt = (Integer)CommonConfig.PRO_PICK_RANGE.get();
            int confDmt = (Integer)CommonConfig.PRO_PICK_DIAMETER.get();
            switch (facing) {
                case UP: {
                    int xStart = -(confDmt / 2);
                    int xEnd = confDmt / 2;
                    int yStart = -confAmt;
                    int yEnd = 0;
                    int zStart = -(confDmt / 2);
                    int zEnd = confDmt / 2;
                    this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                    break;
                }
                case DOWN: {
                    int xStart = -(confDmt / 2);
                    int xEnd = confDmt / 2;
                    int yStart = 0;
                    int yEnd = confAmt;
                    int zStart = -(confDmt / 2);
                    int zEnd = confDmt / 2;
                    this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                    break;
                }
                case NORTH: {
                    int xStart = -(confDmt / 2);
                    int xEnd = confDmt / 2;
                    int yStart = -(confDmt / 2);
                    int yEnd = confDmt / 2;
                    int zStart = 0;
                    int zEnd = confAmt;
                    this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                    break;
                }
                case SOUTH: {
                    int xStart = -(confDmt / 2);
                    int xEnd = confDmt / 2;
                    int yStart = -(confDmt / 2);
                    int yEnd = confDmt / 2;
                    int zStart = -confAmt;
                    int zEnd = 0;
                    this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                    break;
                }
                case EAST: {
                    int xStart = -confAmt;
                    int xEnd = 0;
                    int yStart = -(confDmt / 2);
                    int yEnd = confDmt / 2;
                    int zStart = -(confDmt / 2);
                    int zEnd = confDmt / 2;
                    this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                    break;
                }
                case WEST: {
                    int xStart = 0;
                    int xEnd = confAmt;
                    int yStart = -(confDmt / 2);
                    int yEnd = confDmt / 2;
                    int zStart = -(confDmt / 2);
                    int zEnd = confDmt / 2;
                    this.prospect(player, stack, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                }
            }
            player.func_184609_a(hand);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean prospect(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction facing, int xStart, int xEnd, int yStart, int yEnd, int zStart, int zEnd) {
        HashSet<BlockState> foundBlocks = new HashSet<BlockState>();
        HashSet<BlockPos> foundBlockPos = new HashSet<BlockPos>();
        HashSet<BlockState> depositBlocks = Prospecting.getDepositBlocks();
        for (int x = xStart; x <= xEnd; ++x) {
            for (int y = yStart; y <= yEnd; ++y) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos tmpPos = pos.func_177982_a(x, y, z);
                    BlockState state = world.func_180495_p(tmpPos);
                    if (!depositBlocks.contains(state)) continue;
                    foundBlocks.add(state);
                    foundBlockPos.add(tmpPos);
                }
            }
        }
        if (!foundBlocks.isEmpty()) {
            Geolosys.proxy.sendProspectingMessage(player, foundBlocks, facing.func_176734_d());
            foundBlockPos.forEach(_pos -> world.func_184133_a(null, _pos, SoundEvents.field_187692_g, SoundCategory.PLAYERS, 0.15f, 2.0f));
            return true;
        }
        return this.prospectChunk(world, stack, pos, player);
    }

    private boolean prospectChunk(World world, ItemStack stack, BlockPos pos, PlayerEntity player) {
        HashSet<BlockState> foundBlocks = new HashSet<BlockState>();
        HashSet<BlockState> depositBlocks = Prospecting.getDepositBlocks();
        ChunkPos tempPos = new ChunkPos(pos);
        for (int x = tempPos.func_180334_c(); x <= tempPos.func_180332_e(); ++x) {
            for (int z = tempPos.func_180333_d(); z <= tempPos.func_180330_f(); ++z) {
                for (int y = 0; y < world.func_217301_I(); ++y) {
                    BlockState state = world.func_180495_p(new BlockPos(x, y, z));
                    if (!depositBlocks.contains(state)) continue;
                    foundBlocks.add(state);
                }
            }
        }
        if (!foundBlocks.isEmpty()) {
            Geolosys.proxy.sendProspectingMessage(player, foundBlocks, null);
            return true;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("geolosys.pro_pick.tooltip.nonefound_surface"), true);
        return false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || mc.field_71474_y.field_74330_P || mc.field_71474_y.field_74329_Q) {
            return;
        }
        if (mc.field_71439_g.func_184614_ca().func_77973_b() instanceof ProPickItem || mc.field_71439_g.func_184592_cb().func_77973_b() instanceof ProPickItem) {
            GlStateManager.func_227740_m_();
            GlStateManager.func_227676_b_((int)770, (int)771);
            RenderSystem.disableLighting();
            int seaLvl = mc.field_71439_g.func_130014_f_().func_181545_F();
            int level = (int)((double)seaLvl - mc.field_71439_g.func_226278_cu_());
            if (level < 0) {
                mc.field_71466_p.func_238405_a_(event.getMatrixStack(), I18n.func_135052_a((String)"geolosys.pro_pick.depth.above", (Object[])new Object[]{Math.abs(level)}), (float)((Integer)ClientConfig.PROPICK_HUD_X.get()).intValue(), (float)((Integer)ClientConfig.PROPICK_HUD_Y.get()).intValue(), -1);
            } else if (level == 0) {
                mc.field_71466_p.func_238405_a_(event.getMatrixStack(), I18n.func_135052_a((String)"geolosys.pro_pick.depth.at", (Object[])new Object[0]), (float)((Integer)ClientConfig.PROPICK_HUD_X.get()).intValue(), (float)((Integer)ClientConfig.PROPICK_HUD_Y.get()).intValue(), -1);
            } else {
                mc.field_71466_p.func_238405_a_(event.getMatrixStack(), I18n.func_135052_a((String)"geolosys.pro_pick.depth.below", (Object[])new Object[]{Math.abs(level)}), (float)((Integer)ClientConfig.PROPICK_HUD_X.get()).intValue(), (float)((Integer)ClientConfig.PROPICK_HUD_Y.get()).intValue(), -1);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

