/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.network;

import com.oitsjustjose.geolosys.Geolosys;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;

public class PacketHelpers {
    public static final String BLOCK_NBT_NAME = "blocks";
    public static final String BLOCKPOS_NBT_NAME = "positions";

    public static CompoundNBT encodeBlocks(HashSet<BlockState> blocks) {
        CompoundNBT comp = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (BlockState b : blocks) {
            list.add((Object)NBTUtil.func_190009_a((BlockState)b));
        }
        comp.func_218657_a(BLOCK_NBT_NAME, (INBT)list);
        return comp;
    }

    public static HashSet<BlockState> decodeBlocks(CompoundNBT comp) {
        HashSet<BlockState> ret = new HashSet<BlockState>();
        ListNBT list = comp.func_150295_c(BLOCK_NBT_NAME, 10);
        list.forEach(c -> {
            if (c instanceof CompoundNBT) {
                ret.add(NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)c)));
            } else {
                Geolosys.getInstance().LOGGER.error("The following compound appears to be broken: {}", c);
            }
        });
        return ret;
    }

    public static CompoundNBT encodeBlockPosns(HashSet<BlockPos> pos) {
        CompoundNBT comp = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (BlockPos p : pos) {
            list.add((Object)NBTUtil.func_186859_a((BlockPos)p));
        }
        comp.func_218657_a(BLOCKPOS_NBT_NAME, (INBT)list);
        return comp;
    }

    public static HashSet<BlockPos> decodeBlockPosns(CompoundNBT comp) {
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        ListNBT list = comp.func_150295_c(BLOCKPOS_NBT_NAME, 10);
        list.forEach(c -> {
            if (c instanceof CompoundNBT) {
                ret.add(NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)c)));
            } else {
                Geolosys.getInstance().LOGGER.error("The following compound appears to be broken: {}", c);
            }
        });
        return ret;
    }

    public static String messagify(HashSet<BlockState> blocks) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        for (BlockState b : blocks) {
            sb.append(new ItemStack((IItemProvider)b.func_177230_c()).func_200301_q().getString());
            if (idx + 2 == blocks.size()) {
                sb.append(" & ");
            } else if (idx + 1 != blocks.size()) {
                sb.append(", ");
            }
            ++idx;
        }
        return sb.toString();
    }
}

