/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.network;

import com.oitsjustjose.geolosys.common.network.PacketHelpers;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketStackSurface {
    public HashSet<BlockState> blocks;

    public PacketStackSurface(PacketBuffer buf) {
        CompoundNBT comp = buf.func_150793_b();
        this.blocks = PacketHelpers.decodeBlocks(comp);
    }

    public PacketStackSurface(HashSet<BlockState> d1) {
        this.blocks = d1;
    }

    public static PacketStackSurface decode(PacketBuffer buf) {
        return new PacketStackSurface(buf);
    }

    public static void encode(PacketStackSurface msg, PacketBuffer buf) {
        buf.func_150786_a(PacketHelpers.encodeBlocks(msg.blocks));
    }

    public void handleServer(Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(PacketStackSurface msg, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                PacketStackSurface.sendProspectingMessage((PlayerEntity)mc.field_71439_g, PacketHelpers.messagify(msg.blocks));
            });
        }
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendProspectingMessage(PlayerEntity player, Object ... messageDecorators) {
        TranslationTextComponent msg = new TranslationTextComponent("geolosys.pro_pick.tooltip.found_surface", messageDecorators);
        player.func_146105_b((ITextComponent)msg, true);
    }
}

