/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.network;

import com.oitsjustjose.geolosys.common.network.PacketHelpers;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketStackUnderground {
    public HashSet<BlockState> blocks;
    public String direction;

    public PacketStackUnderground(PacketBuffer buf) {
        CompoundNBT comp = buf.func_150793_b();
        this.blocks = PacketHelpers.decodeBlocks(comp);
        this.direction = buf.func_218666_n();
    }

    public PacketStackUnderground(HashSet<BlockState> d1, String d2) {
        this.blocks = d1;
        this.direction = d2;
    }

    public static PacketStackUnderground decode(PacketBuffer buf) {
        return new PacketStackUnderground(buf);
    }

    public static void encode(PacketStackUnderground msg, PacketBuffer buf) {
        buf.func_150786_a(PacketHelpers.encodeBlocks(msg.blocks));
        buf.func_180714_a(msg.direction);
    }

    public void handleServer(Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(PacketStackUnderground msg, Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.get().enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                PacketStackUnderground.sendProspectingMessage((PlayerEntity)mc.field_71439_g, PacketHelpers.messagify(msg.blocks), msg.direction);
            });
        }
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendProspectingMessage(PlayerEntity player, Object ... messageDecorators) {
        TranslationTextComponent msg = new TranslationTextComponent("geolosys.pro_pick.tooltip.found", messageDecorators);
        player.func_146105_b((ITextComponent)msg, true);
    }
}

