/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoExposedOreFeature;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.ReplaceBlockFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public class OreRemover {
    private static List<Block> toRm = Arrays.asList(Blocks.field_150366_p, Blocks.field_150365_q, Blocks.field_150369_x, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o, Blocks.field_150450_ax, Blocks.field_196766_fg, Blocks.field_235334_I_, Blocks.field_235398_nh_, Blocks.field_196654_e, Blocks.field_196656_g, Blocks.field_196650_c, Blocks.field_196686_dc);
    public static List<Supplier<ConfiguredFeature<?, ?>>> removed = new LinkedList();

    private static void featureRemover(Block targetBlock, Supplier<ConfiguredFeature<?, ?>> targetFeature) {
        if (targetBlock != null && toRm.contains(targetBlock)) {
            removed.add(targetFeature);
            if (((Boolean)CommonConfig.ADVANCED_DEBUG_WORLD_GEN.get()).booleanValue()) {
                Geolosys.getInstance().LOGGER.debug("{} removed from worldgen", (Object)targetBlock.getRegistryName());
            }
        }
    }

    public static List<Supplier<ConfiguredFeature<?, ?>>> filterFeatures(List<Supplier<ConfiguredFeature<?, ?>>> features) {
        for (Supplier<ConfiguredFeature<?, ?>> feature : features) {
            OreFeatureConfig config;
            Block targetBlock = null;
            ConfiguredFeature<?, ?> targetFeature = FeatureUtils.getFeature(feature.get());
            if (targetFeature.field_222737_a instanceof OreFeature || targetFeature.field_222737_a instanceof NoExposedOreFeature) {
                config = (OreFeatureConfig)targetFeature.field_222738_b;
                targetBlock = config.field_202444_d.func_177230_c();
                OreRemover.featureRemover(targetBlock, feature);
                continue;
            }
            if (!(targetFeature.field_222737_a instanceof ReplaceBlockFeature)) continue;
            config = (ReplaceBlockConfig)targetFeature.field_222738_b;
            targetBlock = config.field_202458_b.func_177230_c();
            OreRemover.featureRemover(targetBlock, feature);
        }
        return removed;
    }

    public static int process(BiomeGenerationSettingsBuilder settings) {
        ArrayList toKeep = new ArrayList();
        int total = 0;
        int newTotal = 0;
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            int start = settings.getFeatures(stage).size();
            total += start;
            settings.getFeatures(stage).forEach(supp -> {
                OreFeatureConfig conf;
                ConfiguredFeature configuredFeature = (ConfiguredFeature)supp.get();
                IFeatureConfig config = configuredFeature.field_222738_b;
                while (config instanceof DecoratedFeatureConfig) {
                    DecoratedFeatureConfig dconfig = (DecoratedFeatureConfig)config;
                    config = ((ConfiguredFeature)dconfig.field_214689_a.get()).field_222738_b;
                }
                if (config instanceof OreFeatureConfig) {
                    conf = (OreFeatureConfig)config;
                    if (!toRm.contains(conf.field_202444_d.func_177230_c())) {
                        toKeep.add(supp);
                    }
                } else if (config instanceof ReplaceBlockConfig) {
                    conf = (ReplaceBlockConfig)config;
                    if (!toRm.contains(conf.field_202458_b.func_177230_c())) {
                        toKeep.add(supp);
                    }
                } else {
                    toKeep.add(supp);
                }
            });
            settings.getFeatures(stage).clear();
            settings.getFeatures(stage).addAll(toKeep);
            newTotal += settings.getFeatures(stage).size();
        }
        return newTotal - total;
    }
}

