/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.OreRemover;
import com.oitsjustjose.geolosys.common.world.feature.DepositFeature;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlutonRegistry {
    private ArrayList<IDeposit> deposits = new ArrayList();
    private static final List<GenerationStage.Decoration> decorations = new LinkedList<GenerationStage.Decoration>();

    public void clear() {
        this.deposits = new ArrayList();
    }

    public ArrayList<IDeposit> getOres() {
        return (ArrayList)this.deposits.clone();
    }

    public boolean addDeposit(IDeposit ore) {
        return this.deposits.add(ore);
    }

    @Nullable
    public IDeposit pick(ISeedReader reader, BlockPos pos, Random rand) {
        ArrayList choices = (ArrayList)this.deposits.clone();
        choices.removeIf(dep -> {
            ResourceLocation dim = reader.func_201672_e().func_234923_W_().func_240901_a_();
            boolean isDimFilterBl = dep.isDimensionFilterBl();
            for (String dim2Raw : dep.getDimensionFilter()) {
                boolean match = new ResourceLocation(dim2Raw).equals((Object)dim);
                if ((!isDimFilterBl || !match) && (isDimFilterBl || match)) continue;
                return true;
            }
            return false;
        });
        if (choices.size() == 0) {
            return null;
        }
        if (rand.nextInt(3) == 0 && choices.stream().anyMatch(dep -> dep.hasBiomeRestrictions() && dep.canPlaceInBiome(reader.func_226691_t_(pos)))) {
            choices.removeIf(dep -> !dep.hasBiomeRestrictions() || !dep.canPlaceInBiome(reader.func_226691_t_(pos)));
        }
        int totalWt = 0;
        for (IDeposit d : choices) {
            totalWt += d.getGenWt();
        }
        int rng = rand.nextInt(totalWt);
        for (IDeposit d : choices) {
            int wt = d.getGenWt();
            if (rng < wt) {
                return d;
            }
            rng -= wt;
        }
        Geolosys.getInstance().LOGGER.error("Could not reach decision on pluton to generate at PlutonRegistry#pick");
        return null;
    }

    @SubscribeEvent
    public void onBiomesLoaded(BiomeLoadingEvent evt) {
        BiomeGenerationSettingsBuilder settings = evt.getGeneration();
        if (((Boolean)CommonConfig.REMOVE_VANILLA_ORES.get()).booleanValue()) {
            for (GenerationStage.Decoration deco : decorations) {
                FeatureUtils.destroyFeature(settings.getFeatures(deco), OreRemover.filterFeatures(settings.getFeatures(deco)));
            }
        }
        DepositFeature o = new DepositFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
        settings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, o.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e));
    }

    static {
        decorations.add(GenerationStage.Decoration.UNDERGROUND_ORES);
        decorations.add(GenerationStage.Decoration.UNDERGROUND_DECORATION);
    }
}

