/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.WorldGenRegion;

public class SampleUtils {
    private static ArrayList<BlockState> samplePlacementBlacklist = new ArrayList();
    private static Random random = new Random();

    @Nullable
    public static BlockPos getSamplePosition(ISeedReader reader, ChunkPos chunkPos) {
        return SampleUtils.getSamplePosition(reader, chunkPos, -1);
    }

    @Nullable
    public static BlockPos getSamplePosition(ISeedReader reader, ChunkPos chunkPos, int spread) {
        if (!(reader instanceof WorldGenRegion)) {
            return null;
        }
        WorldGenRegion world = (WorldGenRegion)reader;
        int usedSpread = Math.max(8, spread);
        int xCenter = (chunkPos.func_180334_c() + chunkPos.func_180332_e()) / 2;
        int zCenter = (chunkPos.func_180333_d() + chunkPos.func_180330_f()) / 2;
        int blockPosX = xCenter + random.nextInt(usedSpread) * (reader.func_201674_k().nextBoolean() ? 1 : -1);
        int blockPosZ = zCenter + random.nextInt(usedSpread) * (reader.func_201674_k().nextBoolean() ? 1 : -1);
        if (!world.func_217354_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
            return null;
        }
        BlockPos searchPosUp = new BlockPos(blockPosX, world.func_181545_F(), blockPosZ);
        BlockPos searchPosDown = new BlockPos(blockPosX, world.func_181545_F(), blockPosZ);
        while (searchPosUp.func_177956_o() < world.func_217301_I()) {
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)searchPosUp.func_177977_b(), (Direction)Direction.UP) && SampleUtils.canReplace((ISeedReader)world, searchPosUp) && SampleUtils.canReplace((ISeedReader)world, searchPosUp.func_177984_a()) && SampleUtils.canPlaceOn((ISeedReader)world, searchPosUp)) {
                return searchPosUp;
            }
            searchPosUp = searchPosUp.func_177984_a();
        }
        while (searchPosDown.func_177956_o() > 0) {
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)searchPosDown.func_177977_b(), (Direction)Direction.UP) && SampleUtils.canReplace((ISeedReader)world, searchPosDown) && SampleUtils.canReplace((ISeedReader)world, searchPosDown.func_177984_a()) && SampleUtils.canPlaceOn((ISeedReader)world, searchPosDown)) {
                return searchPosDown;
            }
            searchPosDown = searchPosDown.func_177977_b();
        }
        return null;
    }

    public static boolean canPlaceOn(ISeedReader reader, BlockPos pos) {
        return !samplePlacementBlacklist.contains(reader.func_180495_p(pos.func_177977_b())) && Block.func_220055_a((IWorldReader)reader, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public static boolean canReplace(ISeedReader reader, BlockPos pos) {
        BlockState state = reader.func_180495_p(pos);
        Material mat = state.func_185904_a();
        return BlockTags.field_206952_E.func_230235_a_((Object)state.func_177230_c()) || mat.func_76222_j();
    }

    public static boolean isInWater(ISeedReader reader, BlockPos pos) {
        return reader.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j;
    }

    public static boolean inNonWaterFluid(ISeedReader reader, BlockPos pos) {
        return reader.func_180495_p(pos).func_185904_a().func_76224_d() && !SampleUtils.isInWater(reader, pos);
    }

    public static boolean isWithinRange(int posA, int posB, int range) {
        return Math.abs(posA - posB) <= range;
    }

    public static void addSamplePlacementBlacklist(Block block) {
        samplePlacementBlacklist.add(block.func_176223_P());
    }
}

