/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.capability;

import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class DepositCapability
implements IDepositCapability {
    private ConcurrentLinkedQueue<ChunkPos> oreGenMap = new ConcurrentLinkedQueue();
    private Map<BlockPos, BlockState> pendingBlocks = new ConcurrentHashMap<BlockPos, BlockState>();
    private Map<UUID, Boolean> giveMap = new ConcurrentHashMap<UUID, Boolean>();

    @Override
    public ConcurrentLinkedQueue<ChunkPos> getGenMap() {
        return this.oreGenMap;
    }

    @Override
    public Map<BlockPos, BlockState> getPendingBlocks() {
        return this.pendingBlocks;
    }

    @Override
    public void putPendingBlock(BlockPos pos, BlockState state) {
        this.pendingBlocks.put(pos, state);
    }

    @Override
    public BlockState getPendingBlock(BlockPos pos) {
        BlockState ret = this.pendingBlocks.get(pos);
        return ret;
    }

    @Override
    public void setPlutonGenerated(ChunkPos pos) {
        this.oreGenMap.add(pos);
    }

    @Override
    public boolean hasPlutonGenerated(ChunkPos pos) {
        return this.oreGenMap.contains(pos);
    }

    @Override
    public boolean hasPlayerReceivedManual(UUID uuid) {
        return this.giveMap.containsKey(uuid);
    }

    @Override
    public void setPlayerReceivedManual(UUID uuid) {
        this.giveMap.put(uuid, true);
    }

    @Override
    public Map<UUID, Boolean> getGivenMap() {
        return this.giveMap;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("WorldOreDeposits", (INBT)new CompoundNBT());
        compound.func_218657_a("PendingBlocks", (INBT)new CompoundNBT());
        compound.func_218657_a("PlayersGifted", (INBT)new CompoundNBT());
        CompoundNBT oreDeposits = compound.func_74775_l("WorldOreDeposits");
        CompoundNBT pendingBlocks = compound.func_74775_l("PendingBlocks");
        CompoundNBT playersGifted = compound.func_74775_l("PlayersGifted");
        this.getGenMap().forEach(cp -> oreDeposits.func_74757_a(this.serializeChunkPos((ChunkPos)cp), true));
        this.getPendingBlocks().forEach((pos, state) -> pendingBlocks.func_218657_a(this.serializeBlockPos((BlockPos)pos), (INBT)NBTUtil.func_190009_a((BlockState)state)));
        this.getGivenMap().forEach((x, y) -> playersGifted.func_74757_a(x.toString(), y.booleanValue()));
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        CompoundNBT oreDeposits = compound.func_74775_l("WorldOreDeposits");
        CompoundNBT pendingBlocks = compound.func_74775_l("PendingBlocks");
        CompoundNBT playersGifted = compound.func_74775_l("PlayersGifted");
        oreDeposits.func_150296_c().forEach(key -> this.setPlutonGenerated(this.deSerializeChunkPos((String)key)));
        pendingBlocks.func_150296_c().forEach(key -> this.putPendingBlock(this.deSerializeBlockPos((String)key), NBTUtil.func_190008_d((CompoundNBT)((CompoundNBT)Objects.requireNonNull(pendingBlocks.func_74781_a(key))))));
        playersGifted.func_150296_c().forEach(key -> this.setPlayerReceivedManual(UUID.fromString(key)));
    }

    private String serializeChunkPos(ChunkPos pos) {
        return pos.field_77276_a + "," + pos.field_77275_b;
    }

    private String serializeBlockPos(BlockPos pos) {
        return pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p();
    }

    private ChunkPos deSerializeChunkPos(String asStr) {
        String[] parts = asStr.split(",");
        return new ChunkPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    private BlockPos deSerializeBlockPos(String asStr) {
        String[] parts = asStr.split(",");
        return new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }
}

