/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.api.GeolosysAPI;
import com.oitsjustjose.geolosys.api.world.IDeposit;
import com.oitsjustjose.geolosys.common.config.CommonConfig;
import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import com.oitsjustjose.geolosys.common.world.feature.FeatureUtils;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class DepositFeature
extends Feature<NoFeatureConfig> {
    public DepositFeature(Codec<NoFeatureConfig> p_i231976_1_) {
        super(p_i231976_1_);
    }

    @ParametersAreNonnullByDefault
    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        boolean anyGenerated;
        if (generator instanceof FlatChunkGenerator) {
            return false;
        }
        IDepositCapability cap = (IDepositCapability)reader.func_201672_e().getCapability(GeolosysAPI.GEOLOSYS_WORLD_CAPABILITY).orElse(null);
        if (cap == null) {
            Geolosys.getInstance().LOGGER.error("NULL PLUTON CAPABILITY!!!");
            return false;
        }
        boolean placedPending = this.placePendingBlocks(reader, cap, pos);
        ChunkPos chunkPos = new ChunkPos(pos);
        if (cap.hasPlutonGenerated(chunkPos)) {
            return false;
        }
        IDeposit pluton = GeolosysAPI.plutonRegistry.pick(reader, pos, rand);
        if (pluton == null) {
            return false;
        }
        if (rand.nextInt((Integer)CommonConfig.CHUNK_SKIP_CHANCE.get()) > pluton.getGenWt()) {
            return false;
        }
        boolean bl = anyGenerated = pluton.generate(reader, pos, cap) > 0;
        if (anyGenerated) {
            pluton.afterGen(reader, pos, cap);
            cap.setPlutonGenerated(chunkPos);
            return true;
        }
        return placedPending;
    }

    private boolean placePendingBlocks(ISeedReader reader, IDepositCapability cap, BlockPos pos) {
        boolean placedAny = false;
        for (Map.Entry<BlockPos, BlockState> e : cap.getPendingBlocks().entrySet()) {
            if (!FeatureUtils.isInChunk(new ChunkPos(pos), e.getKey())) continue;
            if (reader.func_180501_a(e.getKey(), e.getValue(), 18)) {
                placedAny = true;
                cap.getPendingBlocks().remove(e.getKey());
                if (!((Boolean)CommonConfig.ADVANCED_DEBUG_WORLD_GEN.get()).booleanValue()) continue;
                Geolosys.getInstance().LOGGER.debug("Generated pending block " + e.getValue().func_177230_c().getRegistryName().toString() + " at " + e.getKey());
                continue;
            }
            if (!((Boolean)CommonConfig.DEBUG_WORLD_GEN.get()).booleanValue()) continue;
            Geolosys.getInstance().LOGGER.error("FAILED to generate pending block " + e.getValue().func_177230_c().getRegistryName().toString() + " at " + e.getKey());
        }
        return placedAny;
    }
}

