/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.world.feature;

import com.oitsjustjose.geolosys.common.world.capability.IDepositCapability;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;

public class FeatureUtils {
    public static boolean isInChunk(ChunkPos chunkPos, BlockPos pos) {
        return new ChunkPos(pos).equals((Object)chunkPos);
    }

    public static ConfiguredFeature<?, ?> getFeature(ConfiguredFeature<?, ?> feature) {
        ConfiguredFeature currentFeature = feature;
        if (currentFeature.field_222737_a instanceof DecoratedFeature) {
            do {
                currentFeature = (ConfiguredFeature)((DecoratedFeatureConfig)currentFeature.func_242767_c()).field_214689_a.get();
            } while (currentFeature.field_222737_a instanceof DecoratedFeature);
        }
        return currentFeature;
    }

    public static void destroyFeature(List<Supplier<ConfiguredFeature<?, ?>>> features, List<Supplier<ConfiguredFeature<?, ?>>> destroy) {
        for (Supplier<ConfiguredFeature<?, ?>> feature : destroy) {
            features.remove(feature);
        }
    }

    public static BlockState tryGetBlockState(ISeedReader reader, ChunkPos chunk, BlockPos pos) {
        if (reader.func_217354_b(chunk.field_77276_a, chunk.field_77275_b)) {
            return reader.func_180495_p(pos);
        }
        return Blocks.field_180401_cv.func_176223_P();
    }

    public static boolean tryPlaceBlock(ISeedReader reader, ChunkPos chunk, BlockPos pos, BlockState state, IDepositCapability cap) {
        if (FeatureUtils.isInChunk(chunk, pos) && reader.func_217354_b(chunk.field_77276_a, chunk.field_77275_b)) {
            boolean ret = reader.func_180501_a(pos, state, 18);
            return ret;
        }
        cap.putPendingBlock(new BlockPos((Vector3i)pos), state);
        return false;
    }

    public static void fixSnowyBlock(ISeedReader reader, BlockPos posPlaced) {
        BlockState below = reader.func_180495_p(posPlaced.func_177977_b());
        if (below.func_235901_b_((Property)BlockStateProperties.field_208196_w)) {
            reader.func_180501_a(posPlaced.func_177977_b(), (BlockState)below.func_206870_a((Property)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(false)), 18);
        }
    }
}

